/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSwitchFix
implements LocalQuickFix,
IntentionAction {
    protected final SmartPsiElementPointer<PsiSwitchBlock> myBlock;

    public BaseSwitchFix(@NotNull PsiSwitchBlock block) {
        this.myBlock = SmartPointerManager.createPointer((PsiElement)block);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.invoke();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.invoke();
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected abstract void invoke();

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiSwitchBlock startSwitch = (PsiSwitchBlock)this.myBlock.getElement();
        if (startSwitch == null) {
            return false;
        }
        int offset = Math.min(editor.getCaretModel().getOffset(), startSwitch.getTextRange().getEndOffset() - 1);
        PsiSwitchBlock currentSwitch = (PsiSwitchBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.findElementAt(offset), (Class[])new Class[]{PsiSwitchBlock.class});
        return currentSwitch == startSwitch;
    }

    @Nullable
    static Editor prepareForTemplateAndObtainEditor(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        Project project = element.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
        if (topLevelFile == null || document != topLevelFile.getViewProvider().getDocument()) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        return editor;
    }
}

