/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DeleteUnnecessaryStatementFix
extends InspectionGadgetsFix {
    private final String name;

    public DeleteUnnecessaryStatementFix(@NonNls String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", this.name);
    }

    @NotNull
    public String getFamilyName() {
        return "Remove redundant statement";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement keywordElement = descriptor.getPsiElement();
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)keywordElement, PsiStatement.class);
        if (statement == null) {
            return;
        }
        DeleteUnnecessaryStatementFix.deleteUnnecessaryStatement(statement);
    }

    public static void deleteUnnecessaryStatement(PsiStatement statement) {
        CommentTracker ct = new CommentTracker();
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiDoWhileStatement || parent instanceof PsiForeachStatement || parent instanceof PsiForStatement) {
            ct.replaceAndRestoreComments((PsiElement)statement, "{}");
        } else {
            ct.deleteAndRestoreComments((PsiElement)statement);
        }
    }
}

