/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InlineGetterSetterCallFix
extends InspectionGadgetsFix {
    private final boolean myGetter;

    public InlineGetterSetterCallFix(boolean getter) {
        this.myGetter = getter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return this.myGetter ? InspectionGadgetsBundle.message("call.to.simple.getter.in.class.inline.quickfix", new Object[0]) : InspectionGadgetsBundle.message("call.to.simple.setter.in.class.inline.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("inline.call.quickfix", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiField field;
        PsiElement nameElement = descriptor.getPsiElement();
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)nameElement.getParent();
        if (methodExpression == null) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiField psiField = field = this.myGetter ? PropertyUtil.getFieldOfGetter(method) : PropertyUtil.getFieldOfSetter(method);
        if (field == null) {
            return;
        }
        String name = field.getName();
        if (name == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        StringBuilder newText = new StringBuilder();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            newText.append(tracker.text((PsiElement)qualifier)).append('.');
        } else {
            PsiVariable variable = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedVariable(name, (PsiElement)methodExpression);
            if (variable != field) {
                newText.append("this.");
            }
        }
        newText.append(name);
        if (!this.myGetter) {
            newText.append("=").append(methodCallExpression.getArgumentList().getExpressions()[0].getText());
        }
        tracker.replaceAndRestoreComments((PsiElement)methodCallExpression, newText.toString());
    }
}

