/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeClassFinalFix
extends InspectionGadgetsFix {
    private final String className;

    public MakeClassFinalFix(PsiClass aClass) {
        this.className = aClass.getName();
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("make.class.final.fix.name", this.className);
    }

    @NotNull
    public String getFamilyName() {
        return "Make class final";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        boolean conflictsDialogOK;
        PsiElement element = descriptor.getPsiElement();
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (containingClass == null) {
            return;
        }
        PsiModifierList modifierList = containingClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!this.isOnTheFly()) {
            if (ClassInheritorsSearch.search((PsiClass)containingClass).findFirst() != null) {
                return;
            }
            MakeClassFinalFix.doMakeFinal(modifierList);
            return;
        }
        MultiMap conflicts = new MultiMap();
        Query search = ClassInheritorsSearch.search((PsiClass)containingClass);
        search.forEach(aClass -> {
            conflicts.putValue((Object)containingClass, (Object)InspectionGadgetsBundle.message("0.will.no.longer.be.overridable.by.1", RefactoringUIUtil.getDescription((PsiElement)containingClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false)));
            return true;
        });
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(element.getProject(), conflicts, () -> MakeClassFinalFix.doMakeFinal(modifierList));
            conflictsDialogOK = conflictsDialog.showAndGet();
        } else {
            conflictsDialogOK = true;
        }
        if (conflictsDialogOK) {
            MakeClassFinalFix.doMakeFinal(modifierList);
        }
    }

    private static void doMakeFinal(PsiModifierList modifierList) {
        WriteAction.run(() -> {
            modifierList.setModifierProperty("final", true);
            modifierList.setModifierProperty("abstract", false);
        });
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

