/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        if (!FinalUtils.canBeFinal((PsiVariable)field)) {
            return null;
        }
        String name = field.getName();
        return new MakeFieldFinalFix(name);
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(PsiField field) {
        return new MakeFieldFinalFix(field.getName());
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("make.field.final.quickfix", this.fieldName);
    }

    @NotNull
    public String getFamilyName() {
        return "Make final";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiField field;
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            field = (PsiField)target;
        } else {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiField)) {
                return;
            }
            field = (PsiField)parent;
        }
        field.normalizeDeclaration();
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("volatile", false);
        modifierList.setModifierProperty("final", true);
    }
}

