/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class NormalizeDeclarationFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("normalize.declaration.quickfix", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement variableNameElement = descriptor.getPsiElement();
        PsiVariable parent = (PsiVariable)variableNameElement.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof PsiField) {
            parent.normalizeDeclaration();
            return;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiDeclarationStatement)) {
            return;
        }
        PsiElement greatGrandParent = grandParent.getParent();
        if (greatGrandParent instanceof PsiForStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)grandParent;
            NormalizeDeclarationFix.splitMultipleDeclarationInForStatementInitialization(declarationStatement);
            return;
        }
        parent.normalizeDeclaration();
    }

    private static void splitMultipleDeclarationInForStatementInitialization(PsiDeclarationStatement declarationStatement) {
        PsiElement declaredElement;
        int i;
        PsiCodeBlock codeBlock;
        PsiBlockStatement blockStatement;
        PsiElement forStatement = declarationStatement.getParent();
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        Project project = forStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement greatGreatGrandParent = forStatement.getParent();
        if (!(greatGreatGrandParent instanceof PsiCodeBlock)) {
            blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", forStatement);
            codeBlock = blockStatement.getCodeBlock();
        } else {
            blockStatement = null;
            codeBlock = null;
        }
        for (i = 1; i < declaredElements.length; ++i) {
            declaredElement = declaredElements[i];
            if (!(declaredElement instanceof PsiVariable)) continue;
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiType type2 = variable.getType();
            String typeText = type2.getCanonicalText();
            StringBuilder newStatementText = new StringBuilder(typeText);
            newStatementText.append(' ');
            newStatementText.append(variable.getName());
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                newStatementText.append('=');
                newStatementText.append(initializer.getText());
            }
            newStatementText.append(';');
            PsiStatement newStatement = factory.createStatementFromText(newStatementText.toString(), forStatement);
            if (codeBlock == null) {
                greatGreatGrandParent.addBefore((PsiElement)newStatement, forStatement);
                continue;
            }
            codeBlock.add((PsiElement)newStatement);
        }
        for (i = 1; i < declaredElements.length; ++i) {
            declaredElement = declaredElements[i];
            if (!(declaredElement instanceof PsiVariable)) continue;
            declaredElement.delete();
        }
        if (codeBlock != null) {
            codeBlock.add(forStatement);
            forStatement.replace((PsiElement)blockStatement);
        }
    }
}

