/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class RemoveModifierFix
extends InspectionGadgetsFix {
    private final String modifierText;

    public RemoveModifierFix(String modifierText) {
        this.modifierText = modifierText;
    }

    @NotNull
    public String getFamilyName() {
        return "Remove modifier";
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("remove.modifier.quickfix", this.modifierText);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement modifierElement = descriptor.getPsiElement();
        RemoveModifierFix.deleteElement(modifierElement);
    }
}

