/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodOverridesConcreteMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("abstract.method.overrides.concrete.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("abstract.method.overrides.concrete.method.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesConcreteMethodVisitor();
    }

    private static class AbstractMethodOverridesConcreteMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesConcreteMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] superMethods;
            if (method.isConstructor()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!method.hasModifierProperty("abstract")) {
                return;
            }
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null) continue;
                String superClassName = superClass.getQualifiedName();
                if (superClass.isInterface() || "java.lang.Object".equals(superClassName) || superMethod.hasModifierProperty("abstract")) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }
    }
}

