/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.InheritanceUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class InterfaceNeverImplementedInspection
extends BaseInspection {
    public boolean ignoreInterfacesThatOnlyDeclareConstants = false;
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    public void writeSettings(@NotNull Element node) {
        this.defaultWriteSettings(node, "ignorableAnnotations");
        this.ignorableAnnotations.writeSettings(node, "ignorableAnnotations");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("interface.never.implemented.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        return AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)aClass, (List<String>)((Object)this.ignorableAnnotations));
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel annotationsPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("interface.never.implemented.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInterfacesThatOnlyDeclareConstants");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        panel.add((Component)annotationsPanel, constraints);
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        panel.add((Component)checkBox, constraints);
        return panel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("interface.never.implemented.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceNeverImplementedVisitor();
    }

    private class InterfaceNeverImplementedVisitor
    extends BaseInspectionVisitor {
        private InterfaceNeverImplementedVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (InterfaceNeverImplementedInspection.this.ignoreInterfacesThatOnlyDeclareConstants && aClass.getMethods().length == 0 && aClass.getFields().length != 0) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)InterfaceNeverImplementedInspection.this.ignorableAnnotations), (int)0) || InheritanceUtil.hasImplementation(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

