/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterTypePreventsOverridingInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("parameter.type.prevents.overriding.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String qualifiedName1 = (String)infos[0];
        String packageName = StringUtil.getPackageName((String)qualifiedName1);
        String qualifiedName2 = (String)infos[1];
        String superPackageName = StringUtil.getPackageName((String)qualifiedName2);
        return InspectionGadgetsBundle.message("parameter.type.prevents.overriding.problem.descriptor", packageName, superPackageName);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ParameterTypePreventsOverridingFix((String)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterTypePreventsOverridingVisitor();
    }

    private static class ParameterTypePreventsOverridingVisitor
    extends BaseInspectionVisitor {
        private ParameterTypePreventsOverridingVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            super.visitMethod(method);
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount == 0) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiClass superClass = containingClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            String name = method.getName();
            block0: for (PsiMethod superMethod : superMethods = superClass.findMethodsByName(name, true)) {
                PsiType type2;
                PsiParameterList superParameterList;
                PsiType superReturnType = superMethod.getReturnType();
                if (superReturnType == null || !superReturnType.isAssignableFrom(returnType) || (superParameterList = superMethod.getParameterList()).getParametersCount() != parameterCount) continue;
                PsiParameter[] superParameters = superParameterList.getParameters();
                Map problemTypeElements = ContainerUtilRt.newHashMap((int)2);
                for (int i = 0; i < parameters2.length; ++i) {
                    PsiParameter parameter2 = parameters2[i];
                    PsiParameter superParameter = superParameters[i];
                    type2 = parameter2.getType();
                    PsiType superType = superParameter.getType();
                    if (!(superType instanceof PsiClassType) || type2.equals(superType)) continue;
                    if (!(type2 instanceof PsiClassType) || !type2.getPresentableText().equals(superType.getPresentableText())) {
                        return;
                    }
                    PsiTypeElement typeElement = parameter2.getTypeElement();
                    if (typeElement == null) {
                        return;
                    }
                    PsiTypeElement superParameterTypeElement = superParameter.getTypeElement();
                    if (superParameterTypeElement == null) continue block0;
                    problemTypeElements.put(typeElement, (PsiClassType)superType);
                }
                for (Map.Entry entry : problemTypeElements.entrySet()) {
                    PsiTypeElement typeElement = (PsiTypeElement)entry.getKey();
                    type2 = (PsiClassType)typeElement.getType();
                    PsiClass aClass1 = type2.resolve();
                    if (aClass1 == null || aClass1 instanceof PsiTypeParameter) {
                        return;
                    }
                    PsiClassType classType = (PsiClassType)entry.getValue();
                    PsiClass aClass2 = classType.resolve();
                    if (aClass2 == null || aClass2 instanceof PsiTypeParameter) continue;
                    this.registerError((PsiElement)typeElement, type2.getCanonicalText(), classType.getCanonicalText());
                }
            }
        }
    }

    private static class ParameterTypePreventsOverridingFix
    extends InspectionGadgetsFix {
        private final String myNewTypeText;

        ParameterTypePreventsOverridingFix(String newTypeText) {
            this.myNewTypeText = newTypeText;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("parameter.type.prevents.overriding.quickfix", this.myNewTypeText);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("parameter.type.prevents.overriding.family.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)typeElement.getProject());
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(this.myNewTypeText, (PsiElement)typeElement);
            typeElement.replace((PsiElement)newTypeElement);
        }
    }
}

