/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspection
extends BaseInspection {
    public final ExternalizableStringSet annotations = new ExternalizableStringSet("javax.annotation.OverridingMethodsMustInvokeSuper");
    public boolean ignoreEmptySuperMethods;
    public boolean ignoreDefaultSuperMethods;
    public boolean onlyReportWhenAnnotated = true;

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.annotations), null);
        CheckBox checkBox1 = new CheckBox("Only report when super method is annotated by:", (InspectionProfileEntry)this, "onlyReportWhenAnnotated");
        MultipleCheckboxOptionsPanel checkBoxPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        checkBoxPanel.addCheckbox(InspectionGadgetsBundle.message("refused.bequest.ignore.empty.super.methods.option", new Object[0]), "ignoreEmptySuperMethods");
        checkBoxPanel.addCheckbox(InspectionGadgetsBundle.message("refused.bequest.ignore.default.super.methods.option", new Object[0]), "ignoreDefaultSuperMethods");
        panel.add((Component)checkBox1, "North");
        panel.add((Component)annotationsListControl, "Center");
        panel.add((Component)checkBoxPanel, "South");
        return panel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RefusedBequestFix();
    }

    @NotNull
    public String getID() {
        return "MethodDoesntCallSuperMethod";
    }

    public void writeSettings(@NotNull Element node) {
        this.defaultWriteSettings(node, "onlyReportWhenAnnotated", "annotations", "ignoreDefaultSuperMethods");
        this.writeBooleanOption(node, "onlyReportWhenAnnotated", false);
        this.writeBooleanOption(node, "ignoreDefaultSuperMethods", false);
        this.annotations.writeSettings(node, "annotations");
    }

    public void readSettings(@NotNull Element node) {
        this.onlyReportWhenAnnotated = false;
        super.readSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("refused.bequest.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("refused.bequest.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RefusedBequestVisitor();
    }

    private class RefusedBequestVisitor
    extends BaseInspectionVisitor {
        private RefusedBequestVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            super.visitMethod(method);
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod superMethod = this.getDirectSuperMethod(method);
            if (superMethod == null) {
                return;
            }
            String methodName = method.getName();
            if (!"clone".equals(methodName) && (superClass = superMethod.getContainingClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            if (RefusedBequestInspection.this.ignoreEmptySuperMethods && this.isTrivial(superMethod)) {
                return;
            }
            boolean isClone = CloneUtils.isClone(method);
            if (RefusedBequestInspection.this.onlyReportWhenAnnotated && !AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, (Collection)((Object)RefusedBequestInspection.this.annotations), (int)0) && (!isClone && !this.isJUnitSetUpOrTearDown(method) && !MethodUtils.isFinalize(method) || this.isTrivial(superMethod))) {
                return;
            }
            if (isClone && ClassUtils.isSingleton(method.getContainingClass())) {
                return;
            }
            if (MethodCallUtils.containsSuperMethodCall(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isTrivial(PsiMethod method) {
            PsiElement element = method.getNavigationElement();
            return MethodUtils.isTrivial(element instanceof PsiMethod ? (PsiMethod)element : method, true);
        }

        private boolean isJUnitSetUpOrTearDown(PsiMethod method) {
            String name = method.getName();
            if (!"setUp".equals(name) && !"tearDown".equals(name)) {
                return false;
            }
            if (!method.getParameterList().isEmpty()) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase");
        }

        @Nullable
        private PsiMethod getDirectSuperMethod(PsiMethod method) {
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null || superMethod.hasModifierProperty("abstract") || RefusedBequestInspection.this.ignoreDefaultSuperMethods && superMethod.hasModifierProperty("default")) {
                return null;
            }
            return superMethod;
        }
    }

    private static class RefusedBequestFix
    extends InspectionGadgetsFix {
        private RefusedBequestFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Insert call to super method";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            assert (method != null);
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            PsiType returnType = method.getReturnType();
            StringBuilder statementText = new StringBuilder();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (returnType != null && !PsiType.VOID.equals((Object)returnType)) {
                if (JavaCodeStyleSettings.getInstance((PsiFile)method.getContainingFile()).GENERATE_FINAL_LOCALS) {
                    statementText.append("final ");
                }
                statementText.append(returnType.getCanonicalText()).append(' ');
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo baseNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, returnType);
                SuggestedNameInfo nameInfo = codeStyleManager.suggestUniqueVariableName(baseNameInfo, (PsiElement)body2, true);
                statementText.append(nameInfo.names.length > 0 ? nameInfo.names[0] : "result");
                statementText.append('=');
                MethodSignatureBackedByPsiMethod superMethodSignature = MethodUtils.getSuperMethodSignature(method);
                if (superMethodSignature == null) {
                    return;
                }
                PsiMethod superMethod = superMethodSignature.getMethod();
                PsiType superReturnType = superMethod.getReturnType();
                PsiType substitutedType = superMethodSignature.getSubstitutor().substitute(superReturnType);
                if (superReturnType != null && !returnType.isAssignableFrom(substitutedType)) {
                    statementText.append('(').append(returnType.getCanonicalText()).append(')');
                }
            }
            statementText.append("super.").append(methodName.getText()).append('(');
            boolean comma = false;
            for (SuggestedNameInfo parameter2 : method.getParameterList().getParameters()) {
                if (comma) {
                    statementText.append(',');
                } else {
                    comma = true;
                }
                statementText.append(parameter2.getName());
            }
            statementText.append(");");
            PsiStatement newStatement = factory.createStatementFromText(statementText.toString(), null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            PsiJavaToken brace = body2.getLBrace();
            PsiElement element = body2.addAfter((PsiElement)newStatement, (PsiElement)brace);
            PsiElement element1 = styleManager.reformat(element);
            PsiElement element2 = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element1);
            if (this.isOnTheFly()) {
                HighlightUtils.highlightElement(element2);
                if (element2 instanceof PsiDeclarationStatement) {
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)element2;
                    PsiLocalVariable variable = (PsiLocalVariable)declarationStatement.getDeclaredElements()[0];
                    HighlightUtils.showRenameTemplate((PsiElement)body2, (PsiNameIdentifierOwner)variable, new PsiReference[0]);
                }
            }
        }
    }
}

