/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeInitializerExplicitFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceVariableInitializationInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        return "InstanceVariableMayNotBeInitialized";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("instance.variable.may.not.be.initialized.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Boolean junitTestCase = (Boolean)infos[0];
        if (junitTestCase.booleanValue()) {
            return InspectionGadgetsBundle.message("instance.Variable.may.not.be.initialized.problem.descriptor.junit", new Object[0]);
        }
        return InspectionGadgetsBundle.message("instance.variable.may.not.be.initialized.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignorePrimitives");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeInitializerExplicitFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableInitializationVisitor();
    }

    private class InstanceVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiType fieldType;
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            if (NullableNotNullManager.isNullable((PsiModifierListOwner)field)) {
                return;
            }
            if (InstanceVariableInitializationInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(fieldType = field.getType())) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
                if (!provider.isImplicitWrite((PsiElement)field)) continue;
                return;
            }
            boolean isTestClass = TestUtils.isJUnitTestClass(aClass);
            if (isTestClass && this.isInitializedInSetup(field, aClass)) {
                return;
            }
            if (this.isInitializedInInitializer(field)) {
                return;
            }
            if (this.isInitializedInConstructors(field, aClass)) {
                return;
            }
            if (isTestClass) {
                this.registerFieldError(field, Boolean.TRUE);
            } else {
                this.registerFieldError(field, Boolean.FALSE);
            }
        }

        private boolean isInitializedInConstructors(PsiField field, PsiClass aClass) {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return false;
            }
            for (PsiMethod constructor : constructors) {
                if (InitializationUtils.methodAssignsVariableOrFails(constructor, (PsiVariable)field)) continue;
                return false;
            }
            return true;
        }

        private boolean isInitializedInSetup(PsiField field, PsiClass aClass) {
            PsiMethod setupMethod = this.getSetupMethod(aClass);
            return InitializationUtils.methodAssignsVariableOrFails(setupMethod, (PsiVariable)field);
        }

        @Nullable
        private PsiMethod getSetupMethod(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.findMethodsByName("setUp", false)) {
                PsiParameterList parameterList;
                if (method.hasModifierProperty("static") || !(parameterList = method.getParameterList()).isEmpty() || !PsiType.VOID.equals((Object)method.getReturnType())) continue;
                return method;
            }
            return null;
        }

        private boolean isInitializedInInitializer(@NotNull PsiField field) {
            PsiField[] fields;
            PsiClassInitializer[] initializers;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return false;
            }
            for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                PsiCodeBlock body2;
                if (initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body2 = initializer.getBody(), (PsiVariable)field)) continue;
                return true;
            }
            for (PsiField otherField : fields = aClass.getFields()) {
                PsiExpression initializer;
                if (field.equals(otherField) || otherField.hasModifierProperty("static") || !InitializationUtils.expressionAssignsVariableOrFails(initializer = otherField.getInitializer(), (PsiVariable)field)) continue;
                return true;
            }
            return false;
        }
    }
}

