/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableUninitializedUseInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @NotNull
    public String getID() {
        return "StaticVariableUsedBeforeInitialization";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("static.variable.used.before.initialization.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("static.variable.used.before.initialization.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignorePrimitives");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableInitializationVisitor();
    }

    private class StaticVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private StaticVariableInitializationVisitor() {
        }

        /*
         * WARNING - void declaration
         */
        public void visitClass(PsiClass aClass) {
            PsiField[] fields = aClass.getFields();
            if (aClass.isEnum()) {
                return;
            }
            for (PsiField field : fields) {
                void var13_17;
                PsiExpression[] moreBadReads;
                PsiType type2;
                if (!field.hasModifierProperty("static") || field.getInitializer() != null || StaticVariableUninitializedUseInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(type2 = field.getType())) continue;
                UninitializedReadCollector uninitializedReadCollector = new UninitializedReadCollector();
                boolean assignedInInitializer = Arrays.stream(aClass.getInitializers()).filter(initializer -> initializer.hasModifierProperty("static")).map(PsiClassInitializer::getBody).anyMatch(body2 -> uninitializedReadCollector.blockAssignsVariable((PsiCodeBlock)body2, (PsiVariable)field));
                if (assignedInInitializer) {
                    PsiExpression[] badReads;
                    for (PsiExpression psiExpression : badReads = uninitializedReadCollector.getUninitializedReads()) {
                        this.registerError((PsiElement)psiExpression, new Object[0]);
                    }
                    continue;
                }
                PsiMethod[] methods = aClass.getMethods();
                for (PsiExpression psiExpression : methods) {
                    if (!psiExpression.hasModifierProperty("static")) continue;
                    PsiCodeBlock body3 = psiExpression.getBody();
                    uninitializedReadCollector.blockAssignsVariable(body3, (PsiVariable)field);
                }
                PsiExpression[] psiExpressionArray = moreBadReads = uninitializedReadCollector.getUninitializedReads();
                int n = psiExpressionArray.length;
                boolean bl = false;
                while (var13_17 < n) {
                    PsiExpression badRead = psiExpressionArray[var13_17];
                    this.registerError((PsiElement)badRead, new Object[0]);
                    ++var13_17;
                }
            }
        }
    }
}

