/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CallToSuspiciousStringMethodInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("call.to.suspicious.string.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("call.to.suspicious.string.method.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSuspiciousStringMethodVisitor();
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiModifierListOwner annotatableArgument;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        ArrayList<DelegatingFix> result = new ArrayList<DelegatingFix>();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        if (annotatableQualifier != null) {
            DelegatingFix fix2 = new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableQualifier, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
            result.add(fix2);
        }
        if ((annotatableArgument = NonNlsUtils.getAnnotatableArgument(methodCallExpression)) != null) {
            DelegatingFix fix3 = new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableArgument, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
            result.add(fix3);
        }
        return result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    private static class CallToSuspiciousStringMethodVisitor
    extends BaseInspectionVisitor {
        private CallToSuspiciousStringMethodVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (!(MethodCallUtils.isEqualsCall(expression2) || MethodCallUtils.isEqualsIgnoreCaseCall(expression2) || MethodCallUtils.isCompareToCall(expression2) || MethodCallUtils.isCompareToIgnoreCaseCall(expression2))) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1 || NonNlsUtils.isNonNlsAnnotated(arguments[0])) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }
    }
}

