/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInLoopConditionInspection
extends BaseInspection {
    public boolean ignoreIterationMethods = true;

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceVariableFix(false){

            @Override
            @NotNull
            public String getFamilyName() {
                return InspectionGadgetsBundle.message("introduce.variable.may.change.semantics.quickfix", new Object[0]);
            }
        };
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.call.in.loop.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.call.in.loop.condition.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore iteration method calls", (InspectionProfileEntry)this, "ignoreIterationMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCallInLoopConditionVisitor();
    }

    private class MethodCallInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private MethodCallInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForMethodCalls(condition2);
        }

        private void checkForMethodCalls(PsiExpression condition2) {
            JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (MethodCallInLoopConditionInspection.this.ignoreIterationMethods) {
                        PsiMethod method = expression2.resolveMethod();
                        if (MethodCallUtils.isCallToMethod(expression2, "java.util.Iterator", (PsiType)PsiType.BOOLEAN, "hasNext", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.ListIterator", (PsiType)PsiType.BOOLEAN, "hasPrevious", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.sql.ResultSet", (PsiType)PsiType.BOOLEAN, "next", new PsiType[0]) || MethodCallUtils.isCallToMethod(expression2, "java.util.Enumeration", (PsiType)PsiType.BOOLEAN, "hasMoreElements", new PsiType[0])) {
                            return;
                        }
                    }
                    MethodCallInLoopConditionVisitor.this.registerMethodCallError(expression2, new Object[0]);
                }
            };
            condition2.accept((PsiElementVisitor)visitor);
        }
    }
}

