/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutNoArgConstructorInspection
extends BaseInspection {
    public boolean m_ignoreClassesWithNoConstructors = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.without.no.arg.constructor.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.without.no.arg.constructor.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreClassesWithNoConstructors");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("class.without.no.arg.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutNoArgConstructorVisitor();
    }

    private class ClassWithoutNoArgConstructorVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutNoArgConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (ClassWithoutNoArgConstructorInspection.this.m_ignoreClassesWithNoConstructors && !this.classHasConstructor(aClass)) {
                return;
            }
            if (this.classHasNoArgConstructor(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean classHasNoArgConstructor(PsiClass aClass) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiParameterList parameterList = constructor.getParameterList();
                if (!parameterList.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean classHasConstructor(PsiClass aClass) {
            PsiMethod[] constructors = aClass.getConstructors();
            return constructors.length != 0;
        }
    }
}

