/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DanglingJavadocInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("dangling.javadoc.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("dangling.javadoc.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return new InspectionGadgetsFix[]{new DeleteCommentFix(), new ConvertCommentFix()};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DanglingJavadocVisitor();
    }

    private static class DanglingJavadocVisitor
    extends BaseInspectionVisitor {
        private DanglingJavadocVisitor() {
        }

        public void visitDocComment(PsiDocComment comment) {
            super.visitDocComment(comment);
            if (comment.getOwner() != null) {
                return;
            }
            if (JavaDocUtil.isInsidePackageInfo(comment) && PsiTreeUtil.skipWhitespacesForward((PsiElement)comment) instanceof PsiPackageStatement && "package-info.java".equals(comment.getContainingFile().getName())) {
                return;
            }
            this.registerError(comment.getFirstChild(), new Object[0]);
        }
    }

    private static class DeleteCommentFix
    extends InspectionGadgetsFix {
        private DeleteCommentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("dangling.javadoc.delete.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            element.getParent().delete();
        }
    }

    private static class ConvertCommentFix
    extends InspectionGadgetsFix {
        private ConvertCommentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("dangling.javadoc.convert.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement docComment = element.getParent();
            StringBuilder newCommentText = new StringBuilder();
            for (PsiElement child : docComment.getChildren()) {
                if (child instanceof PsiDocToken) {
                    PsiDocToken docToken = (PsiDocToken)child;
                    IElementType tokenType = docToken.getTokenType();
                    if (JavaDocTokenType.DOC_COMMENT_START.equals(tokenType)) {
                        newCommentText.append("/*");
                        continue;
                    }
                    if (JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS.equals(tokenType)) continue;
                    newCommentText.append(child.getText());
                    continue;
                }
                newCommentText.append(child.getText());
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiComment newComment = factory.createCommentFromText(newCommentText.toString(), element);
            docComment.replace((PsiElement)newComment);
        }
    }
}

