/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PackageDotHtmlMayBePackageInfoInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean packageInfoExists = (Boolean)infos[1];
        if (packageInfoExists) {
            return new DeletePackageDotHtmlFix();
        }
        String aPackage = (String)infos[0];
        return new PackageDotHtmlMayBePackageInfoFix(aPackage);
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[1]).booleanValue()) {
            return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.exists.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageDotHtmlMayBePackageInfoVisitor();
    }

    private static class PackageDotHtmlMayBePackageInfoVisitor
    extends BaseInspectionVisitor {
        private PackageDotHtmlMayBePackageInfoVisitor() {
        }

        public void visitFile(PsiFile file) {
            super.visitFile(file);
            if (!(file instanceof XmlFile)) {
                return;
            }
            String fileName = file.getName();
            if (!"package.html".equals(fileName)) {
                return;
            }
            PsiDirectory directory = file.getContainingDirectory();
            if (directory == null) {
                return;
            }
            String aPackage = PackageDotHtmlMayBePackageInfoVisitor.getPackage(directory);
            if (aPackage == null) {
                return;
            }
            boolean exists = directory.findFile("package-info.java") != null;
            this.registerError((PsiElement)file, aPackage, exists);
        }

        public static String getPackage(@NotNull PsiDirectory directory) {
            VirtualFile virtualFile = directory.getVirtualFile();
            Project project = directory.getProject();
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
            return fileIndex.getPackageNameByDirectory(virtualFile);
        }
    }

    private static class PackageDotHtmlMayBePackageInfoFix
    extends InspectionGadgetsFix {
        private final String aPackage;

        PackageDotHtmlMayBePackageInfoFix(String aPackage) {
            this.aPackage = aPackage;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.convert.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)element;
            PsiDirectory directory = xmlFile.getContainingDirectory();
            if (directory == null) {
                return;
            }
            PsiFile file = directory.findFile("package-info.java");
            if (file != null) {
                return;
            }
            String packageInfoText = PackageDotHtmlMayBePackageInfoFix.getPackageInfoText(xmlFile);
            PsiJavaFile packageInfoFile = (PsiJavaFile)directory.createFile("package-info.java");
            String commentText = PackageDotHtmlMayBePackageInfoFix.buildCommentText(packageInfoText);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiDocComment comment = elementFactory.createDocCommentFromText(commentText);
            if (!this.aPackage.isEmpty()) {
                PsiPackageStatement packageStatement = elementFactory.createPackageStatement(this.aPackage);
                PsiElement addedElement = packageInfoFile.add((PsiElement)packageStatement);
                packageInfoFile.addBefore((PsiElement)comment, addedElement);
            } else {
                packageInfoFile.add((PsiElement)comment);
            }
            xmlFile.delete();
            if (this.isOnTheFly()) {
                packageInfoFile.navigate(true);
            }
        }

        @NotNull
        private static String buildCommentText(String packageInfoText) {
            StringBuilder commentText = new StringBuilder("/**\n");
            String[] lines = StringUtil.splitByLines((String)packageInfoText);
            boolean appended = false;
            for (String line : lines) {
                if (!appended && line.isEmpty()) continue;
                commentText.append(" * ").append(line).append('\n');
                appended = true;
            }
            commentText.append("*/");
            return commentText.toString();
        }

        @NotNull
        static String getPackageInfoText(XmlFile xmlFile) {
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null) {
                PsiElement[] children;
                for (PsiElement child : children = rootTag.getChildren()) {
                    HtmlTag htmlTag;
                    String name;
                    if (!(child instanceof HtmlTag) || !"body".equalsIgnoreCase(name = (htmlTag = (HtmlTag)child).getName())) continue;
                    XmlTagValue value2 = htmlTag.getValue();
                    return value2.getText();
                }
            }
            return xmlFile.getText();
        }
    }

    private static class DeletePackageDotHtmlFix
    extends InspectionGadgetsFix {
        private DeletePackageDotHtmlFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.delete.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlFile)) {
                return;
            }
            element.delete();
        }
    }
}

