/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInfoWithoutPackageInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("package.info.java.without.package.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("package.info.without.package.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new PackageInfoWithoutPackageFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageInfoWithoutPackageVisitor();
    }

    private static class PackageInfoWithoutPackageVisitor
    extends BaseInspectionVisitor {
        private PackageInfoWithoutPackageVisitor() {
        }

        public void visitJavaFile(PsiJavaFile file) {
            String name = file.getName();
            if (!"package-info.java".equals(name)) {
                return;
            }
            PsiPackageStatement packageStatement = file.getPackageStatement();
            if (packageStatement != null) {
                return;
            }
            PsiDirectory directory = file.getContainingDirectory();
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                return;
            }
            String packageName = aPackage.getQualifiedName();
            if (packageName.isEmpty() || !PsiDirectoryFactory.getInstance((Project)file.getProject()).isValidPackageName(packageName) || !PackageInfoWithoutPackageVisitor.isValid(file)) {
                return;
            }
            this.registerError((PsiElement)file, packageName);
        }

        private static boolean isValid(PsiJavaFile file) {
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return false;
            }
            PsiElement sibling = importList.getPrevSibling();
            if (!(sibling instanceof PsiComment)) {
                return true;
            }
            String text2 = sibling.getText();
            return !text2.startsWith("/*") || text2.endsWith("*/");
        }
    }

    private static class PackageInfoWithoutPackageFix
    extends InspectionGadgetsFix {
        private final String myPackageName;

        PackageInfoWithoutPackageFix(String packageName) {
            this.myPackageName = packageName;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("package.info.without.package.quickfix", this.myPackageName);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("package.info.without.package.family.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)element;
            file.setPackageName(this.myPackageName);
        }
    }
}

