/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.ReplaceAssertEqualsFix;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AssertEqualsCalledOnArrayInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("assertequals.called.on.arrays.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("assertequals.called.on.arrays.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceAssertEqualsFix("assertArrayEquals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertEqualsOnArrayVisitor();
    }

    private static class AssertEqualsOnArrayVisitor
    extends BaseInspectionVisitor {
        private AssertEqualsOnArrayVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2, false);
            if (assertHint == null) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            int argIndex = assertHint.getArgIndex();
            PsiType type1 = arguments[argIndex].getType();
            PsiType type2 = arguments[argIndex + 1].getType();
            if (!(type1 instanceof PsiArrayType) || !(type2 instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

