/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Consumer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit5AssertionsConverterInspection
extends BaseInspection {
    private String myFrameworkName = "JUnit5";

    JUnit5AssertionsConverterInspection(String frameworkName) {
        this.myFrameworkName = frameworkName;
    }

    public JUnit5AssertionsConverterInspection() {
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("junit5.assertions.converter.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String name = (String)infos[0];
        String targetClassName = (String)infos[1];
        return InspectionGadgetsBundle.message("junit5.assertions.converter.problem.descriptor", name, targetClassName);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean disabledFix = (Boolean)infos[2];
        return !disabledFix ? new ReplaceObsoleteAssertsFix((String)infos[1]) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfObsoleteAssertVisitor();
    }

    private static String getNewAssertClassName(String methodName) {
        if ("assertThat".equals(methodName)) {
            return "org.hamcrest.MatcherAssert";
        }
        if (methodName.startsWith("assume")) {
            return "org.junit.jupiter.api.Assumptions";
        }
        return "org.junit.jupiter.api.Assertions";
    }

    static class ReplaceObsoleteAssertsFix
    extends InspectionGadgetsFix {
        private final String myBaseClassName;

        ReplaceObsoleteAssertsFix(String baseClassName) {
            this.myBaseClassName = baseClassName;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression message2;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiMethodReferenceExpression) {
                AssertHint assertHint = AssertHint.create((PsiMethodReferenceExpression)element, AssertHint.JUnitCommonAssertNames.ASSERT_METHOD_2_PARAMETER_COUNT::get, false);
                if (assertHint != null) {
                    ReplaceObsoleteAssertsFix.replaceQualifier(project, assertHint.getMethod().getName(), (PsiReferenceExpression)element);
                }
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return;
            }
            AssertHint assertHint = AssertHint.create(methodCallExpression, AssertHint.JUnitCommonAssertNames.ASSERT_METHOD_2_PARAMETER_COUNT::get, false);
            if (assertHint == null) {
                return;
            }
            String methodName = assertHint.getMethod().getName();
            if (!"assertThat".equals(methodName) && (message2 = assertHint.getMessage()) != null) {
                methodCallExpression.getArgumentList().add((PsiElement)message2);
                message2.delete();
            }
            ReplaceObsoleteAssertsFix.replaceQualifier(project, methodName, methodCallExpression.getMethodExpression());
        }

        private static void replaceQualifier(Project project, String methodName, PsiReferenceExpression methodExpression) {
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project).findClass(JUnit5AssertionsConverterInspection.getNewAssertClassName(methodName), methodExpression.getResolveScope());
            if (newAssertClass == null) {
                return;
            }
            String qualifiedName = newAssertClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            methodExpression.setQualifierExpression((PsiExpression)JavaPsiFacade.getElementFactory((Project)project).createReferenceExpression(newAssertClass));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)methodExpression);
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("junit5.assertions.converter.quickfix", this.myBaseClassName);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("junit5.assertions.converter.familyName", new Object[0]);
        }
    }

    private class UseOfObsoleteAssertVisitor
    extends BaseInspectionVisitor {
        private UseOfObsoleteAssertVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            this.doCheck((PsiElement)expression2, (Computable<? extends AssertHint>)((Computable)() -> AssertHint.create(expression2, AssertHint.JUnitCommonAssertNames.ASSERT_METHOD_2_PARAMETER_COUNT::get, false)), (Consumer<? super PsiMethod>)((Consumer)psiMethod -> {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String methodName = psiMethod.getName();
                this.registerMethodCallError(expression2, containingClass.getName(), JUnit5AssertionsConverterInspection.getNewAssertClassName(methodName), this.absentInJUnit5((PsiMethod)psiMethod, methodName));
            }));
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            this.doCheck((PsiElement)expression2, (Computable<? extends AssertHint>)((Computable)() -> AssertHint.create(expression2, AssertHint.JUnitCommonAssertNames.ASSERT_METHOD_2_PARAMETER_COUNT::get, false)), (Consumer<? super PsiMethod>)((Consumer)psiMethod -> {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String methodName = psiMethod.getName();
                this.registerError((PsiElement)expression2, containingClass.getQualifiedName(), JUnit5AssertionsConverterInspection.getNewAssertClassName(methodName), this.absentInJUnit5((PsiMethod)psiMethod, methodName));
            }));
        }

        private void doCheck(PsiElement expression2, Computable<? extends AssertHint> computable, Consumer<? super PsiMethod> registerError) {
            PsiFile file;
            Project project = expression2.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression2);
            if (module == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project).findClass("org.junit.jupiter.api.Assertions", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            if (newAssertClass == null) {
                return;
            }
            AssertHint hint = (AssertHint)computable.compute();
            if (hint == null) {
                return;
            }
            PsiMethod psiMethod = hint.getMethod();
            if (!psiMethod.hasModifierProperty("static")) {
                return;
            }
            if (hint.isMessageOnFirstPosition() && (file = expression2.getContainingFile()) instanceof PsiClassOwner) {
                for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                    TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
                    if (testFramework == null || !JUnit5AssertionsConverterInspection.this.myFrameworkName.equals(testFramework.getName())) continue;
                    registerError.consume((Object)psiMethod);
                    break;
                }
            }
        }

        private boolean absentInJUnit5(PsiMethod psiMethod, String methodName) {
            PsiParameter[] parameters2;
            if ("assertNotEquals".equals(methodName) && (parameters2 = psiMethod.getParameterList().getParameters()).length > 0) {
                int lastParamIdx;
                int n = lastParamIdx = parameters2[0].getType().equalsToText("java.lang.String") ? 3 : 2;
                if (parameters2.length > lastParamIdx && parameters2[lastParamIdx].getType() instanceof PsiPrimitiveType) {
                    return true;
                }
            }
            return false;
        }
    }
}

