/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ParameterizedParametersStaticCollectionInspection
extends BaseInspection {
    protected static final String PARAMETERS_FQN = "org.junit.runners.Parameterized.Parameters";
    private static final String PARAMETERIZED_FQN = "org.junit.runners.Parameterized";

    @Override
    protected InspectionGadgetsFix buildFix(final Object ... infos) {
        return new InspectionGadgetsFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) {
                PsiElement element = descriptor.getPsiElement();
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
                if (method != null && infos[1] instanceof PsiType) {
                    PsiType type2 = (PsiType)infos[1];
                    ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project, method, false, "public", method.getName(), type2, new ParameterInfoImpl[0]);
                    csp.run();
                } else {
                    CreateMethodQuickFix fix2;
                    PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                    if (psiClass != null && (fix2 = CreateMethodQuickFix.createFix(psiClass, "@org.junit.runners.Parameterized.Parameters public static java.util.Collection parameters()", "")) != null) {
                        fix2.applyFix(project, descriptor);
                    }
                }
            }

            @NotNull
            public String getName() {
                return infos.length > 0 ? (String)infos[0] : "Create @Parameterized.Parameters data provider";
            }

            @NotNull
            public String getFamilyName() {
                return "Fix data provider signature";
            }
        };
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return infos.length > 0 ? (String)infos[1] : "Class #ref annotated @RunWith(Parameterized.class) lacks data provider";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitClass(PsiClass aClass) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"org.junit.runner.RunWith"});
                if (annotation != null) {
                    for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                        PsiTypeElement typeElement;
                        PsiAnnotationMemberValue value2 = pair.getValue();
                        if (!(value2 instanceof PsiClassObjectAccessExpression) || !(typeElement = ((PsiClassObjectAccessExpression)value2).getOperand()).getType().getCanonicalText().equals(ParameterizedParametersStaticCollectionInspection.PARAMETERIZED_FQN)) continue;
                        ArrayList<MethodCandidate> candidates = new ArrayList<MethodCandidate>();
                        for (PsiMethod method : aClass.getMethods()) {
                            PsiType returnType = method.getReturnType();
                            PsiClass returnTypeClass = PsiUtil.resolveClassInType((PsiType)returnType);
                            Project project = aClass.getProject();
                            PsiClass collectionsClass = JavaPsiFacade.getInstance((Project)project).findClass(Collection.class.getName(), GlobalSearchScope.allScope((Project)project));
                            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)ParameterizedParametersStaticCollectionInspection.PARAMETERS_FQN, (int)0)) continue;
                            PsiModifierList modifierList = method.getModifierList();
                            String fixMessage = "Make method '" + method.getName() + "' ";
                            String errorString = "Method '#ref()' should";
                            String signatureDescription = "";
                            if (!modifierList.hasModifierProperty("public")) {
                                signatureDescription = signatureDescription + "public";
                                errorString = errorString + " be ";
                            }
                            if (!modifierList.hasModifierProperty("static")) {
                                if (!signatureDescription.isEmpty()) {
                                    signatureDescription = signatureDescription + " static";
                                } else {
                                    signatureDescription = signatureDescription + "static";
                                    errorString = errorString + " be ";
                                }
                            }
                            if (!(collectionsClass == null || returnType instanceof PsiArrayType || returnTypeClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)returnTypeClass, (PsiClass)collectionsClass, (boolean)true))) {
                                if (!signatureDescription.isEmpty()) {
                                    signatureDescription = signatureDescription + " and";
                                }
                                signatureDescription = signatureDescription + " return Collection";
                                returnType = JavaPsiFacade.getElementFactory((Project)project).createType(collectionsClass);
                            }
                            if (!signatureDescription.isEmpty()) {
                                candidates.add(new MethodCandidate(method, fixMessage + signatureDescription, errorString + signatureDescription, returnType));
                                continue;
                            }
                            return;
                        }
                        if (candidates.isEmpty()) {
                            this.registerClassError(aClass, new Object[0]);
                            continue;
                        }
                        for (MethodCandidate candidate : candidates) {
                            this.registerMethodError(candidate.myMethod, candidate.myProblem, candidate.myErrorString, candidate.myReturnType);
                        }
                    }
                }
            }
        };
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "@RunWith(Parameterized.class) without data provider";
    }

    private static class MethodCandidate {
        PsiMethod myMethod;
        String myProblem;
        private final String myErrorString;
        PsiType myReturnType;

        MethodCandidate(PsiMethod method, String problem, String errorString, PsiType returnType) {
            this.myMethod = method;
            this.myProblem = problem;
            this.myErrorString = errorString;
            this.myReturnType = returnType;
        }
    }
}

