/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.MakePublicStaticVoidFix;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestMethodIsPublicVoidNoArgInspection
extends BaseInspection {
    public final List<String> ignorableAnnotations = new ArrayList<String>(Collections.singletonList("mockit.Mocked"));

    @Nullable
    public JComponent createOptionsPanel() {
        return SpecialAnnotationsUtil.createSpecialAnnotationsListControl(this.ignorableAnnotations, InspectionGadgetsBundle.message("ignore.parameter.if.annotated.by", new Object[0]));
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[1];
        return new MakePublicStaticVoidFix(method, false);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "TestMethodWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Problem problem = (Problem)((Object)infos[0]);
        switch (problem) {
            case PARAMETER: {
                return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor1", new Object[0]);
            }
            case NOT_PUBLIC_VOID: {
                return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor2", new Object[0]);
            }
            case STATIC: {
                return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor3", new Object[0]);
            }
        }
        throw new AssertionError();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodIsPublicVoidNoArgVisitor();
    }

    private class TestMethodIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private TestMethodIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiType returnType;
            if (method.isConstructor()) {
                return;
            }
            if (!TestUtils.isJUnit3TestMethod(method) && !TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"org.junit.runner.RunWith", (int)1)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (method.hasModifierProperty("static")) {
                this.registerMethodError(method, new Object[]{Problem.STATIC, method});
                return;
            }
            if (!parameterList.isEmpty()) {
                PsiParameter[] parameters2 = parameterList.getParameters();
                boolean annotated = true;
                for (PsiParameter parameter2 : parameters2) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter2, TestMethodIsPublicVoidNoArgInspection.this.ignorableAnnotations, (int)0)) continue;
                    annotated = false;
                    break;
                }
                if (!annotated) {
                    this.registerMethodError(method, new Object[]{Problem.PARAMETER, method});
                    return;
                }
            }
            if (!PsiType.VOID.equals((Object)(returnType = method.getReturnType())) || !method.hasModifierProperty("public")) {
                this.registerMethodError(method, new Object[]{Problem.NOT_PUBLIC_VOID, method});
            }
        }
    }

    static enum Problem {
        STATIC,
        NOT_PUBLIC_VOID,
        PARAMETER;

    }
}

