/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.Arrays;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TestMethodWithoutAssertionInspection
extends BaseInspection {
    protected final MethodMatcher methodMatcher = new MethodMatcher(false, "assertionMethods").add("org.junit.Assert", "assert.*|fail.*").add("junit.framework.Assert", "assert.*|fail.*").add("org.junit.jupiter.api.Assertions", "assert.*|fail.*").add("org.assertj.core.api.Assertions", "assertThat").add("org.assertj.core.api.WithAssertions", "assertThat").add("com.google.common.truth.Truth", "assert.*").add("com.google.common.truth.Truth8", "assert.*").add("org.mockito.Mockito", "verify.*").add("org.mockito.InOrder", "verify").add("org.junit.rules.ExpectedException", "expect.*").add("org.hamcrest.MatcherAssert", "assertThat").add("mockit.Verifications", "Verifications").finishDefault();
    public boolean assertKeywordIsAssertion;
    public boolean ignoreIfExceptionThrown;

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.methodMatcher.getClassNames(), this.methodMatcher.getMethodNamePatterns()), new String[]{"Assertion class name", InspectionGadgetsBundle.message("method.name.regex", new Object[0])}));
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("assert.keyword.is.considered.an.assertion", new Object[0]), (InspectionProfileEntry)this, "assertKeywordIsAssertion");
        CheckBox checkBox2 = new CheckBox("Ignore test methods which declare exceptions", (InspectionProfileEntry)this, "ignoreIfExceptionThrown");
        return new FormBuilder().addComponentFillVertically((JComponent)UiUtils.createAddRemoveTreeClassChooserPanel(table, "Choose assertion class", new String[0]), 0).addComponent((JComponent)checkBox1).addComponent((JComponent)checkBox2).getPanel();
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "JUnitTestMethodWithNoAssertions";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("test.method.without.assertion.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("test.method.without.assertion.problem.descriptor", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        this.methodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.methodMatcher.writeSettings(element);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodWithoutAssertionVisitor();
    }

    private class ContainsAssertionVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsAssertion;

        private ContainsAssertionVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element instanceof PsiCompiledElement) {
                return;
            }
            if (!this.containsAssertion) {
                super.visitElement(element);
            }
        }

        public void visitCallExpression(@NotNull PsiCallExpression call) {
            if (this.containsAssertion) {
                return;
            }
            super.visitCallExpression(call);
            if (TestMethodWithoutAssertionInspection.this.methodMatcher.matches((PsiCall)call)) {
                this.containsAssertion = true;
            }
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            if (this.containsAssertion) {
                return;
            }
            super.visitAssertStatement(statement);
            if (!TestMethodWithoutAssertionInspection.this.assertKeywordIsAssertion) {
                return;
            }
            this.containsAssertion = true;
        }

        boolean containsAssertion() {
            return this.containsAssertion;
        }
    }

    private class TestMethodWithoutAssertionVisitor
    extends BaseInspectionVisitor {
        private TestMethodWithoutAssertionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            super.visitMethod(method);
            if (!TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            if (TestUtils.hasExpectedExceptionAnnotation(method)) {
                return;
            }
            if (TestMethodWithoutAssertionInspection.this.ignoreIfExceptionThrown && method.getThrowsList().getReferenceElements().length > 0) {
                return;
            }
            if (this.containsAssertion((PsiElement)method)) {
                return;
            }
            if (this.lastStatementIsCallToMethodWithAssertion(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean lastStatementIsCallToMethodWithAssertion(PsiMethod method) {
            PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
            if (!(lastStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)lastStatement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null && !(qualifierExpression2 instanceof PsiThisExpression)) {
                return false;
            }
            PsiMethod targetMethod = methodCallExpression.resolveMethod();
            return this.containsAssertion((PsiElement)targetMethod);
        }

        private boolean containsAssertion(PsiElement element) {
            if (element == null) {
                return false;
            }
            ContainsAssertionVisitor visitor = new ContainsAssertionVisitor();
            element.accept((PsiElementVisitor)visitor);
            return visitor.containsAssertion();
        }
    }
}

