/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LoggingUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassWithMultipleLoggersInspection
extends BaseInspection {
    protected final List<String> loggerNames = new ArrayList<String>();
    @NonNls
    public String loggerNamesString = StringUtil.join(LoggingUtils.DEFAULT_LOGGERS, (String)",");

    public ClassWithMultipleLoggersInspection() {
        ClassWithMultipleLoggersInspection.parseString(this.loggerNamesString, this.loggerNames);
    }

    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList(this.loggerNames, InspectionGadgetsBundle.message("logger.class.name", new Object[0]), InspectionGadgetsBundle.message("choose.logger.class", new Object[0]), new String[0]);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("multiple.loggers.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("multiple.loggers.problem.descriptor", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        ClassWithMultipleLoggersInspection.parseString(this.loggerNamesString, this.loggerNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerNamesString = ClassWithMultipleLoggersInspection.formatString(this.loggerNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithMultipleLoggersVisitor();
    }

    private class ClassWithMultipleLoggersVisitor
    extends BaseInspectionVisitor {
        private ClassWithMultipleLoggersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            int numLoggers = 0;
            for (PsiField field : aClass.getFields()) {
                if (!this.isLogger((PsiVariable)field)) continue;
                ++numLoggers;
            }
            if (numLoggers <= 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type2 = variable.getType();
            String text2 = type2.getCanonicalText();
            return ClassWithMultipleLoggersInspection.this.loggerNames.contains(text2);
        }
    }
}

