/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.ui.TextField;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogStatementGuardedByLogConditionInspection
extends BaseInspection {
    final List<String> logMethodNameList = new ArrayList<String>();
    final List<String> logConditionMethodNameList = new ArrayList<String>();
    public String loggerClassName = "java.util.logging.Logger";
    @NonNls
    public String loggerMethodAndconditionMethodNames = "fine,isLoggable(java.util.logging.Level.FINE),finer,isLoggable(java.util.logging.Level.FINER),finest,isLoggable(java.util.logging.Level.FINEST)";
    public boolean flagAllUnguarded = false;

    public LogStatementGuardedByLogConditionInspection() {
        LogStatementGuardedByLogConditionInspection.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    public JComponent createOptionsPanel() {
        TextField loggerClassNameField = new TextField((InspectionProfileEntry)this, "loggerClassName");
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.logMethodNameList, this.logConditionMethodNameList), new String[]{InspectionGadgetsBundle.message("log.method.name", new Object[0]), InspectionGadgetsBundle.message("log.condition.text", new Object[0])}));
        return new FormBuilder().addLabeledComponent(InspectionGadgetsBundle.message("logger.name.option", new Object[0]), (JComponent)loggerClassNameField).addComponentFillVertically((JComponent)UiUtils.createAddRemovePanel(table), 0).addComponent((JComponent)new CheckBox(InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.flag.all.unguarded.option", new Object[0]), (InspectionProfileEntry)this, "flagAllUnguarded")).getPanel();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LogStatementGuardedByLogConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LogStatementGuardedByLogConditionVisitor();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        LogStatementGuardedByLogConditionInspection.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerMethodAndconditionMethodNames = LogStatementGuardedByLogConditionInspection.formatString(this.logMethodNameList, this.logConditionMethodNameList);
        super.writeSettings(element);
    }

    private class LogStatementGuardedByLogConditionVisitor
    extends BaseInspectionVisitor {
        private LogStatementGuardedByLogConditionVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!LogStatementGuardedByLogConditionInspection.this.logMethodNameList.contains(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspection.this.loggerClassName)) {
                return;
            }
            if (this.isSurroundedByLogGuard((PsiElement)expression2, referenceName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            if (!LogStatementGuardedByLogConditionInspection.this.flagAllUnguarded) {
                boolean constant = true;
                for (PsiExpression argument : arguments) {
                    if ((argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)argument)) instanceof PsiLambdaExpression || argument instanceof PsiMethodReferenceExpression || PsiUtil.isConstantExpression((PsiExpression)argument)) continue;
                    constant = false;
                    break;
                }
                if (constant) {
                    return;
                }
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private boolean isSurroundedByLogGuard(PsiElement element, String logMethodName) {
            PsiIfStatement ifStatement;
            while ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) != null) {
                PsiExpression condition2 = ifStatement.getCondition();
                if (this.isLogGuardCheck(condition2, logMethodName)) {
                    return true;
                }
                element = ifStatement;
            }
            return false;
        }

        private boolean isLogGuardCheck(@Nullable PsiExpression expression2, String logMethodName) {
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspection.this.loggerClassName)) {
                    return false;
                }
                String referenceName = methodExpression.getReferenceName();
                if (referenceName == null) {
                    return false;
                }
                int index = LogStatementGuardedByLogConditionInspection.this.logMethodNameList.indexOf(logMethodName);
                String conditionName = LogStatementGuardedByLogConditionInspection.this.logConditionMethodNameList.get(index);
                return conditionName.startsWith(referenceName);
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiExpression[] operands2;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    if (!this.isLogGuardCheck(operand2, logMethodName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class LogStatementGuardedByLogConditionFix
    extends InspectionGadgetsFix {
        private LogStatementGuardedByLogConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element.getParent().getParent();
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            ArrayList<PsiStatement> logStatements = new ArrayList<PsiStatement>();
            logStatements.add(statement);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (this.isSameLogMethodCall(previousStatement, referenceName)) {
                logStatements.add(0, previousStatement);
                previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)previousStatement, PsiStatement.class);
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (this.isSameLogMethodCall(nextStatement, referenceName)) {
                logStatements.add(nextStatement);
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            int index = LogStatementGuardedByLogConditionInspection.this.logMethodNameList.indexOf(referenceName);
            String conditionMethodText = LogStatementGuardedByLogConditionInspection.this.logConditionMethodNameList.get(index);
            String ifStatementText = "if (" + qualifier.getText() + '.' + conditionMethodText + ") {}";
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(ifStatementText, (PsiElement)statement);
            PsiBlockStatement blockStatement = (PsiBlockStatement)ifStatement.getThenBranch();
            if (blockStatement == null) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement logStatement : logStatements) {
                codeBlock.add((PsiElement)logStatement);
            }
            PsiStatement firstStatement = (PsiStatement)logStatements.get(0);
            PsiElement parent = firstStatement.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() != null) {
                PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)statement);
                newBlockStatement.getCodeBlock().add((PsiElement)ifStatement);
                PsiElement result = firstStatement.replace((PsiElement)newBlockStatement);
                codeStyleManager.shortenClassReferences(result);
                return;
            }
            PsiElement result = parent.addBefore((PsiElement)ifStatement, (PsiElement)firstStatement);
            codeStyleManager.shortenClassReferences(result);
            for (PsiStatement logStatement : logStatements) {
                logStatement.delete();
            }
        }

        private boolean isSameLogMethodCall(PsiStatement statement, @NotNull String methodName) {
            if (statement == null) {
                return false;
            }
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!methodName.equals(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspection.this.loggerClassName);
        }
    }
}

