/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LoggingUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PublicMethodWithoutLoggingInspection
extends BaseInspection {
    final List<String> loggerClassNames = new ArrayList<String>();
    public String loggerClassName = StringUtil.join(LoggingUtils.DEFAULT_LOGGERS, (String)",");

    public PublicMethodWithoutLoggingInspection() {
        PublicMethodWithoutLoggingInspection.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList(this.loggerClassNames, InspectionGadgetsBundle.message("logger.class.name", new Object[0]), InspectionGadgetsBundle.message("choose.logger.class", new Object[0]), new String[0]);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("public.method.without.logging.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("public.method.without.logging.problem.descriptor", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        PublicMethodWithoutLoggingInspection.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerClassName = PublicMethodWithoutLoggingInspection.formatString(this.loggerClassNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodWithoutLoggingVisitor();
    }

    private class ContainsLoggingCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsLoggingCall;

        private ContainsLoggingCallVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.containsLoggingCall) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (this.containsLoggingCall) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            if (containingClassName == null) {
                return;
            }
            if (PublicMethodWithoutLoggingInspection.this.loggerClassNames.contains(containingClassName)) {
                this.containsLoggingCall = true;
            }
        }

        boolean containsLoggingCall() {
            return this.containsLoggingCall;
        }
    }

    private class PublicMethodWithoutLoggingVisitor
    extends BaseInspectionVisitor {
        private PublicMethodWithoutLoggingVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            if (PropertyUtil.isSimpleGetter(method) || PropertyUtil.isSimpleSetter(method)) {
                return;
            }
            if (this.containsLoggingCall(body2)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean containsLoggingCall(PsiCodeBlock block) {
            ContainsLoggingCallVisitor visitor = new ContainsLoggingCallVisitor();
            block.accept((PsiElementVisitor)visitor);
            return visitor.containsLoggingCall();
        }
    }
}

