/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ui.FormBuilder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationArgumentToLogCallInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> logNames = new THashSet();
    public int warnLevel = 0;

    @Nullable
    public JComponent createOptionsPanel() {
        final ComboBox comboBox = new ComboBox((Object[])new String[]{InspectionGadgetsBundle.message("all.levels.option", new Object[0]), InspectionGadgetsBundle.message("warn.level.and.lower.option", new Object[0]), InspectionGadgetsBundle.message("info.level.and.lower.option", new Object[0]), InspectionGadgetsBundle.message("debug.level.and.lower.option", new Object[0]), InspectionGadgetsBundle.message("trace.level.option", new Object[0])});
        comboBox.setSelectedIndex(this.warnLevel);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringConcatenationArgumentToLogCallInspection.this.warnLevel = comboBox.getSelectedIndex();
            }
        });
        return new FormBuilder().addLabeledComponent(InspectionGadgetsBundle.message("warn.on.label", new Object[0]), (JComponent)comboBox).addVerticalGap(-1).getPanel();
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.concatenation.argument.to.log.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.concatenation.argument.to.log.call.problem.descriptor", new Object[0]);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.warnLevel != 0) {
            node.addContent(new Element("option").setAttribute("name", "warnLevel").setAttribute("value", String.valueOf(this.warnLevel)));
        }
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (!StringConcatenationArgumentToLogCallFix.isAvailable((PsiExpression)infos[0])) {
            return null;
        }
        return new StringConcatenationArgumentToLogCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationArgumentToLogCallVisitor();
    }

    static {
        logNames.add("trace");
        logNames.add("debug");
        logNames.add("info");
        logNames.add("warn");
        logNames.add("error");
        logNames.add("fatal");
        logNames.add("log");
    }

    private class StringConcatenationArgumentToLogCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationArgumentToLogCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!logNames.contains(referenceName)) {
                return;
            }
            switch (StringConcatenationArgumentToLogCallInspection.this.warnLevel) {
                case 4: {
                    if ("debug".equals(referenceName)) {
                        return;
                    }
                }
                case 3: {
                    if ("info".equals(referenceName)) {
                        return;
                    }
                }
                case 2: {
                    if ("warn".equals(referenceName)) {
                        return;
                    }
                }
                case 1: {
                    if (!"error".equals(referenceName) && !"fatal".equals(referenceName)) break;
                    return;
                }
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.slf4j.Logger") && !InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.apache.logging.log4j.Logger")) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!ExpressionUtils.hasStringType(argument)) {
                if (arguments.length < 2) {
                    return;
                }
                argument = arguments[1];
                if (!ExpressionUtils.hasStringType(argument)) {
                    return;
                }
            }
            if (!this.containsNonConstantConcatenation(argument)) {
                return;
            }
            this.registerMethodCallError(expression2, argument);
        }

        private boolean containsNonConstantConcatenation(@Nullable PsiExpression expression2) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                return this.containsNonConstantConcatenation(parenthesizedExpression.getExpression());
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiExpression[] operands2;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                if (!ExpressionUtils.hasStringType((PsiExpression)polyadicExpression)) {
                    return false;
                }
                if (!JavaTokenType.PLUS.equals(polyadicExpression.getOperationTokenType())) {
                    return false;
                }
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    if (ExpressionUtils.isEvaluatedAtCompileTime(operand2)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class StringConcatenationArgumentToLogCallFix
    extends InspectionGadgetsFix {
        StringConcatenationArgumentToLogCallFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("string.concatenation.argument.to.log.call.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            int usedArguments;
            PsiElement element = descriptor.getPsiElement();
            PsiElement grandParent = element.getParent().getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            StringBuilder newMethodCall = new StringBuilder(methodCallExpression.getMethodExpression().getText());
            newMethodCall.append('(');
            PsiExpression argument = arguments[0];
            if (!(argument instanceof PsiPolyadicExpression)) {
                if (!TypeUtils.expressionHasTypeOrSubtype(argument, "org.slf4j.Marker") || arguments.length < 2) {
                    return;
                }
                newMethodCall.append(argument.getText()).append(',');
                argument = arguments[1];
                usedArguments = 2;
                if (!(argument instanceof PsiPolyadicExpression)) {
                    return;
                }
            } else {
                usedArguments = 1;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)argument;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiMethod[] methods = containingClass.findMethodsByName(methodName, false);
            boolean varArgs = false;
            for (PsiMethod otherMethod : methods) {
                if (!otherMethod.isVarArgs()) continue;
                varArgs = true;
                break;
            }
            ArrayList<PsiExpression> newArguments = new ArrayList<PsiExpression>();
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            boolean addPlus = false;
            boolean inStringLiteral = false;
            for (PsiExpression operand2 : operands2) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand2)) {
                    if (ExpressionUtils.hasStringType(operand2) && operand2 instanceof PsiLiteralExpression) {
                        String text2 = operand2.getText();
                        int count = StringUtil.getOccurrenceCount((String)text2, (String)"{}");
                        for (int i = 0; i < count && usedArguments + i < arguments.length; ++i) {
                            newArguments.add(ParenthesesUtils.stripParentheses((PsiExpression)arguments[i + usedArguments].copy()));
                        }
                        usedArguments += count;
                        if (!inStringLiteral) {
                            if (addPlus) {
                                newMethodCall.append('+');
                            }
                            newMethodCall.append('\"');
                            inStringLiteral = true;
                        }
                        newMethodCall.append(text2, 1, text2.length() - 1);
                    } else {
                        if (inStringLiteral) {
                            newMethodCall.append('\"');
                            inStringLiteral = false;
                        }
                        if (addPlus) {
                            newMethodCall.append('+');
                        }
                        newMethodCall.append(operand2.getText());
                    }
                } else {
                    newArguments.add(ParenthesesUtils.stripParentheses((PsiExpression)operand2.copy()));
                    if (!inStringLiteral) {
                        if (addPlus) {
                            newMethodCall.append('+');
                        }
                        newMethodCall.append('\"');
                        inStringLiteral = true;
                    }
                    newMethodCall.append("{}");
                }
                addPlus = true;
            }
            while (usedArguments < arguments.length) {
                newArguments.add(arguments[usedArguments++]);
            }
            if (inStringLiteral) {
                newMethodCall.append('\"');
            }
            if (!varArgs && newArguments.size() > 2) {
                newMethodCall.append(", new Object[]{");
                boolean comma = false;
                for (PsiExpression newArgument : newArguments) {
                    if (comma) {
                        newMethodCall.append(',');
                    } else {
                        comma = true;
                    }
                    if (newArgument == null) continue;
                    newMethodCall.append(newArgument.getText());
                }
                newMethodCall.append('}');
            } else {
                for (PsiExpression newArgument : newArguments) {
                    newMethodCall.append(',');
                    if (newArgument == null) continue;
                    newMethodCall.append(newArgument.getText());
                }
            }
            newMethodCall.append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newMethodCall.toString());
        }

        public static boolean isAvailable(PsiExpression expression2) {
            PsiExpression[] operands2;
            if (!(expression2 instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand2)) continue;
                return true;
            }
            return false;
        }
    }
}

