/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowablePrintStackTraceInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        return SuppressForTestsScopeFix.build(this, context);
    }

    @NotNull
    public String getID() {
        return "CallToPrintStackTrace";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("printstacktrace.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("printstacktrace.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowablePrintStackTraceVisitor();
    }

    private static class ThrowablePrintStackTraceVisitor
    extends BaseInspectionVisitor {
        private ThrowablePrintStackTraceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            String methodName = MethodCallUtils.getMethodName(expression2);
            if (!"printStackTrace".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)"java.lang.Throwable")) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }
    }
}

