/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class InnerClassReferenceVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiClass innerClass;
    private boolean referencesStaticallyAccessible = true;

    public InnerClassReferenceVisitor(@NotNull PsiClass innerClass) {
        this.innerClass = innerClass;
    }

    public boolean canInnerClassBeStatic() {
        PsiClass superClass = this.innerClass.getSuperClass();
        if (superClass != null && !this.isClassStaticallyAccessible(superClass)) {
            return false;
        }
        return this.referencesStaticallyAccessible;
    }

    private boolean isClassStaticallyAccessible(@NotNull PsiClass aClass) {
        if (PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)aClass, (boolean)false) || aClass.hasModifierProperty("static")) {
            return true;
        }
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)aClass).getOwner();
            return owner != null && PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)owner, (boolean)false);
        }
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)this.innerClass, (PsiClass)containingClass, (boolean)true);
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression2) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitThisExpression(expression2);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression2)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expression2) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitSuperExpression(expression2);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression2)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private boolean hasContainingClassQualifier(PsiQualifiedExpression expression2) {
        PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
        return qualifier != null && !this.innerClass.equals(qualifier.resolve());
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement expression2) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitReferenceElement(expression2);
        if (expression2.isQualified()) {
            return;
        }
        PsiElement target = expression2.resolve();
        if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
            return;
        }
        if (target instanceof PsiMethod || target instanceof PsiField) {
            PsiMember member = (PsiMember)target;
            if (member.hasModifierProperty("static") || PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)member, (boolean)true)) {
                return;
            }
            if (!member.hasModifierProperty("private")) {
                PsiClass containingClass = member.getContainingClass();
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)this.innerClass, (PsiClass)containingClass, (boolean)true)) {
                    return;
                }
                PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
                while (parentClass != null && PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)parentClass, (boolean)true)) {
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                        return;
                    }
                    parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
                }
            }
            this.referencesStaticallyAccessible = false;
        } else if (target instanceof PsiClass && !this.isClassStaticallyAccessible((PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitNewExpression(expression2);
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
        if (classReference2 == null) {
            return;
        }
        PsiElement target = classReference2.resolve();
        if (!(target instanceof PsiClass)) {
            return;
        }
        if (!this.isClassStaticallyAccessible((PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitTypeElement(PsiTypeElement typeElement) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitTypeElement(typeElement);
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
        if (aClass instanceof PsiTypeParameter && !PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)aClass, (boolean)true)) {
            this.referencesStaticallyAccessible = false;
        }
    }
}

