/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemGCInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToSystemGC";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("gc.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("gc.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemGCVisitor();
    }

    private static class SystemGCVisitor
    extends BaseInspectionVisitor {
        private SystemGCVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"gc".equals(methodName)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className) && !"java.lang.Runtime".equals(className)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

