/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NestingDepthVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final int myLimit;
    private int m_maximumDepth;
    private int m_currentDepth;
    private final Set<PsiElement> scopeEntered = new THashSet();

    NestingDepthVisitor(int limit) {
        this.myLimit = limit;
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        boolean isAlreadyCounted;
        PsiElement parent = statement.getParent();
        boolean bl = isAlreadyCounted = parent instanceof PsiDoWhileStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiIfStatement || parent instanceof PsiSynchronizedStatement;
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement);
        }
        super.visitBlockStatement(statement);
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        this.enterScope((PsiElement)statement);
        super.visitDoWhileStatement(statement);
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        this.enterScope((PsiElement)statement);
        super.visitForStatement(statement);
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        PsiStatement elseBranch;
        boolean isAlreadyCounted = false;
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement && statement.equals(elseBranch = ((PsiIfStatement)parent).getElseBranch())) {
            isAlreadyCounted = true;
        }
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement);
        }
        super.visitIfStatement(statement);
    }

    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        this.enterScope((PsiElement)statement);
        super.visitSynchronizedStatement(statement);
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        this.enterScope((PsiElement)statement);
        super.visitTryStatement(statement);
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        this.enterScope((PsiElement)statement);
        super.visitSwitchStatement(statement);
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        this.enterScope((PsiElement)statement);
        super.visitWhileStatement(statement);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        this.exitScope(element);
    }

    private void enterScope(PsiElement element) {
        this.scopeEntered.add(element);
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
        if (this.m_maximumDepth > this.myLimit) {
            this.stopWalking();
        }
    }

    private void exitScope(PsiElement element) {
        if (this.scopeEntered.remove(element)) {
            --this.m_currentDepth;
        }
    }

    int getMaximumDepth() {
        return this.m_maximumDepth;
    }
}

