/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ParametersPerMethodInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        return "MethodWithTooManyParameters";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("parameters.per.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer parameterCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("parameters.per.method.problem.descriptor", parameterCount);
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("parameter.limit.option", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParametersPerMethodVisitor();
    }

    private class ParametersPerMethodVisitor
    extends BaseInspectionVisitor {
        private ParametersPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount <= ParametersPerMethodInspection.this.getLimit()) {
                return;
            }
            if (method.findDeepestSuperMethods().length > 0) {
                return;
            }
            this.registerMethodError(method, parametersCount);
        }
    }
}

