/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ThrownExceptionsPerMethodInspection
extends MethodMetricInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("thrown.exceptions.per.method.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "MethodWithTooExceptionsDeclared";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer exceptionCount = (Integer)infos[0];
        return InspectionGadgetsBundle.message("thrown.exceptions.per.method.problem.descriptor", exceptionCount);
    }

    @Override
    protected int getDefaultLimit() {
        return 3;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("thrown.exceptions.per.method.limit.option", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrownExceptionsPerMethodVisitor();
    }

    private class ThrownExceptionsPerMethodVisitor
    extends BaseInspectionVisitor {
        private ThrownExceptionsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiReferenceList throwList = method.getThrowsList();
            PsiJavaCodeReferenceElement[] thrownExceptions = throwList.getReferenceElements();
            int exceptionCount = thrownExceptions.length;
            if (exceptionCount <= ThrownExceptionsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, exceptionCount);
        }
    }
}

