/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigDecimalLegacyMethodInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("bigdecimal.legacy.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("bigdecimal.legacy.method.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        if (!(value2 instanceof Integer)) {
            return null;
        }
        int roundingMode = (Integer)value2;
        if (roundingMode < 0 || roundingMode > 7) {
            return null;
        }
        return new BigDecimalLegacyMethodFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalLegacyMethodVisitor();
    }

    private static class BigDecimalLegacyMethodVisitor
    extends BaseInspectionVisitor {
        private BigDecimalLegacyMethodVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"setScale".equals(name) && !"divide".equals(name)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (PsiUtilCore.hasErrorElementChild((PsiElement)argumentList)) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 2 && arguments.length != 3) {
                return;
            }
            PsiExpression argument = arguments[arguments.length - 1];
            if (!PsiType.INT.equals((Object)argument.getType())) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.math.BigDecimal")) {
                return;
            }
            this.registerMethodCallError(expression2, argument);
        }
    }

    private static class BigDecimalLegacyMethodFix
    extends InspectionGadgetsFix {
        private BigDecimalLegacyMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("bigdecimal.legacy.method.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement grandParent = element.getParent().getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 2 && arguments.length != 3) {
                return;
            }
            PsiExpression argument = arguments[arguments.length - 1];
            Object value2 = ExpressionUtils.computeConstantExpression(argument);
            if (!(value2 instanceof Integer)) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            int roundingMode = (Integer)value2;
            switch (roundingMode) {
                case 0: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.UP", commentTracker);
                    break;
                }
                case 1: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.DOWN", commentTracker);
                    break;
                }
                case 2: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.CEILING", commentTracker);
                    break;
                }
                case 3: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.FLOOR", commentTracker);
                    break;
                }
                case 4: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.HALF_UP", commentTracker);
                    break;
                }
                case 5: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.HALF_DOWN", commentTracker);
                    break;
                }
                case 6: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.HALF_EVEN", commentTracker);
                    break;
                }
                case 7: {
                    PsiReplacementUtil.replaceExpressionAndShorten(argument, "java.math.RoundingMode.UNNECESSARY", commentTracker);
                }
            }
        }
    }
}

