/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForCanBeForeachInspection
extends BaseInspection {
    public boolean REPORT_INDEXED_LOOP = false;
    public boolean ignoreUntypedCollections;

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForCanBeForeachFix();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("for.can.be.foreach.option", new Object[0]), "REPORT_INDEXED_LOOP");
        panel.addCheckbox(InspectionGadgetsBundle.message("for.can.be.foreach.option2", new Object[0]), "ignoreUntypedCollections");
        return panel;
    }

    static boolean isIndexedListLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Number)) {
            return false;
        }
        Number number = (Number)constant;
        if (number.intValue() != 0) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        Holder collectionHolder = ForCanBeForeachInspection.getCollectionFromSizeComparison(condition2, indexVariable, secondDeclaredElement);
        if (collectionHolder == null) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update2)) {
            return false;
        }
        PsiStatement body2 = forStatement.getBody();
        if (!ForCanBeForeachInspection.isIndexVariableOnlyUsedAsListIndex(collectionHolder, indexVariable, body2)) {
            return false;
        }
        if (collectionHolder != Holder.DUMMY) {
            PsiVariable collection = collectionHolder.getVariable();
            PsiClassType collectionType = (PsiClassType)collection.getType();
            PsiType[] parameters2 = collectionType.getParameters();
            if (ignoreUntypedCollections && parameters2.length == 0) {
                return false;
            }
            return !VariableAccessUtils.variableIsAssigned(collection, (PsiElement)body2);
        }
        return true;
    }

    static boolean isArrayLoopStatement(PsiForStatement forStatement) {
        PsiElement secondDeclaredElement;
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length == 1) {
            secondDeclaredElement = null;
        } else if (declaredElements.length == 2) {
            secondDeclaredElement = declaredElements[1];
        } else {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable indexVariable = (PsiVariable)declaredElement;
        PsiExpression initialValue = indexVariable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(initialValue);
        if (!(constant instanceof Integer)) {
            return false;
        }
        Integer integer = (Integer)constant;
        if (integer != 0) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (!VariableAccessUtils.variableIsIncremented(indexVariable, update2)) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        PsiReferenceExpression arrayReference = ForCanBeForeachInspection.getVariableReferenceFromCondition(condition2, indexVariable, secondDeclaredElement);
        if (arrayReference == null) {
            return false;
        }
        if (!(arrayReference.getType() instanceof PsiArrayType)) {
            return false;
        }
        PsiElement element = arrayReference.resolve();
        if (!(element instanceof PsiVariable)) {
            return false;
        }
        PsiVariable arrayVariable = (PsiVariable)element;
        PsiStatement body2 = forStatement.getBody();
        return body2 == null || ForCanBeForeachInspection.isIndexVariableOnlyUsedAsIndex(arrayVariable, indexVariable, body2) && !VariableAccessUtils.variableIsAssigned(arrayVariable, (PsiElement)body2) && !VariableAccessUtils.arrayContentsAreAssigned(arrayVariable, (PsiElement)body2);
    }

    private static boolean isIndexVariableOnlyUsedAsIndex(@NotNull PsiVariable arrayVariable, @NotNull PsiVariable indexVariable, @Nullable PsiStatement body2) {
        if (body2 == null) {
            return true;
        }
        VariableOnlyUsedAsIndexVisitor visitor = new VariableOnlyUsedAsIndexVisitor(arrayVariable, indexVariable);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    private static boolean isIndexVariableOnlyUsedAsListIndex(Holder collectionHolder, PsiVariable indexVariable, PsiStatement body2) {
        if (body2 == null) {
            return true;
        }
        VariableOnlyUsedAsListIndexVisitor visitor = new VariableOnlyUsedAsListIndexVisitor(collectionHolder, indexVariable);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.isIndexVariableUsedOnlyAsIndex();
    }

    static boolean isCollectionLoopStatement(PsiForStatement forStatement, boolean ignoreUntypedCollections) {
        PsiStatement initialization = forStatement.getInitialization();
        if (!(initialization instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
            return false;
        }
        PsiExpression initialValue = variable.getInitializer();
        if (initialValue == null) {
            return false;
        }
        if (!(initialValue instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
        PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
        String initialCallName = initialMethodExpression.getReferenceName();
        if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
            return false;
        }
        if (!initialCall.getArgumentList().isEmpty()) {
            return false;
        }
        PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(initialMethodExpression);
        PsiType qualifierType = qualifier.getType();
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)qualifierType;
        PsiClass qualifierClass = classType.resolve();
        if (ignoreUntypedCollections) {
            PsiClassType type2 = (PsiClassType)variable.getType();
            PsiType[] parameters2 = type2.getParameters();
            PsiType[] parameters1 = classType.getParameters();
            if (parameters2.length == 0 && parameters1.length == 0) {
                return false;
            }
        }
        if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.lang.Iterable")) {
            return false;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (!ForCanBeForeachInspection.isHasNext(condition2, variable)) {
            return false;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (update2 != null && !(update2 instanceof PsiEmptyStatement)) {
            return false;
        }
        PsiStatement body2 = forStatement.getBody();
        if (body2 == null) {
            return false;
        }
        if (ForCanBeForeachInspection.calculateCallsToIteratorNext(variable, body2) != 1) {
            return false;
        }
        if (ForCanBeForeachInspection.isIteratorMethodCalled(variable, body2)) {
            return false;
        }
        return !VariableAccessUtils.variableIsReturned(variable, (PsiElement)body2) && !VariableAccessUtils.variableIsAssigned(variable, (PsiElement)body2) && !VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)body2);
    }

    private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiStatement body2) {
        if (body2 == null) {
            return 0;
        }
        NumCallsToIteratorNextVisitor visitor = new NumCallsToIteratorNextVisitor(iterator);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.getNumCallsToIteratorNext();
    }

    public static boolean isIteratorMethodCalled(PsiVariable iterator, PsiStatement body2) {
        IteratorMethodCallVisitor visitor = new IteratorMethodCallVisitor(iterator);
        body2.accept((PsiElementVisitor)visitor);
        return visitor.isMethodCalled();
    }

    static boolean isHasNext(PsiExpression condition2, PsiVariable iterator) {
        if (!(condition2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)condition2;
        if (!call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"hasNext".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement target = referenceExpression.resolve();
        return iterator.equals(target);
    }

    @Nullable
    private static PsiReferenceExpression getVariableReferenceFromCondition(PsiExpression condition2, PsiVariable variable, PsiElement secondDeclaredElement) {
        PsiExpression qualifierExpression2;
        PsiReferenceExpression referenceExpression;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ParenthesesUtils.stripParentheses(condition2), PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return null;
        }
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
        if (lhs == null || rhs == null) {
            return null;
        }
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!ExpressionUtils.isReferenceTo(lhs, variable) || !(rhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)rhs;
        } else if (tokenType.equals(JavaTokenType.GT)) {
            if (!ExpressionUtils.isReferenceTo(rhs, variable) || !(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            referenceExpression = (PsiReferenceExpression)lhs;
        } else {
            return null;
        }
        if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)referenceExpression) == null) {
            PsiElement target = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target)) {
                return null;
            }
            if (target instanceof PsiVariable) {
                PsiVariable maxVariable = (PsiVariable)target;
                PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)maxVariable, PsiCodeBlock.class);
                if (context == null || VariableAccessUtils.variableIsAssigned(maxVariable, (PsiElement)context)) {
                    return null;
                }
                PsiExpression expression2 = ParenthesesUtils.stripParentheses(maxVariable.getInitializer());
                if (!(expression2 instanceof PsiReferenceExpression)) {
                    return null;
                }
                referenceExpression = (PsiReferenceExpression)expression2;
                if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)referenceExpression) == null) {
                    return null;
                }
            }
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if ((qualifierExpression2 = referenceExpression.getQualifierExpression()) instanceof PsiReferenceExpression) {
            return (PsiReferenceExpression)qualifierExpression2;
        }
        if (qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression || qualifierExpression2 == null) {
            return referenceExpression;
        }
        return null;
    }

    @Nullable
    private static Holder getCollectionFromSizeComparison(PsiExpression condition2, PsiVariable variable, PsiElement secondDeclaredElement) {
        if (!((condition2 = ParenthesesUtils.stripParentheses(condition2)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        PsiExpression rhs = binaryExpression.getROperand();
        PsiExpression lhs = binaryExpression.getLOperand();
        if (tokenType.equals(JavaTokenType.LT)) {
            if (!ExpressionUtils.isReferenceTo(lhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspection.getCollectionFromListMethodCall(rhs, "size", secondDeclaredElement);
        }
        if (tokenType.equals(JavaTokenType.GT)) {
            if (!ExpressionUtils.isReferenceTo(rhs, variable)) {
                return null;
            }
            return ForCanBeForeachInspection.getCollectionFromListMethodCall(lhs, "size", secondDeclaredElement);
        }
        return null;
    }

    static boolean expressionIsListGetLookup(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression reference = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = reference.getMethodExpression();
        PsiElement resolved = methodExpression.resolve();
        if (!(resolved instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)resolved;
        if (!"get".equals(method.getName())) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.List");
    }

    @Nullable
    private static Holder getCollectionFromListMethodCall(PsiExpression expression2, String methodName, PsiElement secondDeclaredElement) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (secondDeclaredElement != null && !secondDeclaredElement.equals(target)) {
                return null;
            }
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (context == null) {
                return null;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)context)) {
                return null;
            }
            expression2 = ParenthesesUtils.stripParentheses(variable.getInitializer());
        } else if (secondDeclaredElement != null) {
            return null;
        }
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        if (!methodName.equals(referenceName)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.List")) {
            return null;
        }
        PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
            return Holder.DUMMY;
        }
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)target;
        return new Holder(variable);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ForLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("for.can.be.foreach.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("for.can.be.foreach.problem.descriptor", new Object[0]);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForCanBeForeachVisitor();
    }

    @Nullable
    static PsiType getContentType(PsiType type2, String containerClassName) {
        PsiType parameterType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)containerClassName, (int)0, (boolean)true);
        return GenericsUtil.getVariableTypeByExpressionType((PsiType)parameterType);
    }

    static void replaceIteratorNext(PsiElement element, String contentVariableName, PsiVariable iterator, PsiType contentType, PsiElement childToSkip, StringBuilder out) {
        if (ForCanBeForeachInspection.isIteratorNext(element, iterator, contentType)) {
            out.append(contentVariableName);
        } else {
            PsiElement[] children = element.getChildren();
            if (children.length == 0) {
                String text2 = element.getText();
                if ("instanceof".equals(text2) && out.charAt(out.length() - 1) != ' ') {
                    out.append(' ');
                }
                out.append(text2);
            } else {
                boolean skippingWhiteSpace = false;
                for (PsiElement child : children) {
                    if (ForCanBeForeachInspection.shouldSkip(iterator, contentType, child) || child.equals(childToSkip)) {
                        skippingWhiteSpace = true;
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                    skippingWhiteSpace = false;
                    ForCanBeForeachInspection.replaceIteratorNext(child, contentVariableName, iterator, contentType, childToSkip, out);
                }
            }
        }
    }

    static boolean shouldSkip(PsiVariable iterator, PsiType contentType, PsiElement child) {
        if (!(child instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)child;
        PsiExpression expression2 = expressionStatement.getExpression();
        return ForCanBeForeachInspection.isIteratorNext((PsiElement)expression2, iterator, contentType);
    }

    static boolean isIteratorNextDeclaration(PsiStatement statement, PsiVariable iterator, PsiType contentType) {
        if (!(statement instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement declaredElement = declaredElements[0];
        if (!(declaredElement instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)declaredElement;
        PsiExpression initializer = variable.getInitializer();
        return ForCanBeForeachInspection.isIteratorNext((PsiElement)initializer, iterator, contentType);
    }

    static boolean isIteratorNext(PsiElement element, PsiVariable iterator, PsiType contentType) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)element;
            PsiType type2 = castExpression.getType();
            if (type2 == null) {
                return false;
            }
            if (!type2.equals(contentType)) {
                return false;
            }
            PsiExpression operand2 = castExpression.getOperand();
            return ForCanBeForeachInspection.isIteratorNext((PsiElement)operand2, iterator, contentType);
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
        if (!callExpression.getArgumentList().isEmpty()) {
            return false;
        }
        PsiReferenceExpression reference = callExpression.getMethodExpression();
        String referenceName = reference.getReferenceName();
        if (!"next".equals(referenceName)) {
            return false;
        }
        PsiExpression expression2 = reference.getQualifierExpression();
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement target = referenceExpression.resolve();
        return iterator.equals(target);
    }

    static String createNewVariableName(@NotNull PsiElement scope, PsiType type2, @Nullable String containerName) {
        return new VariableNameGenerator(scope, VariableKind.PARAMETER).byCollectionName(containerName).byType(type2).byName("value", "item", "element").generate(true);
    }

    @Nullable
    static PsiStatement getFirstStatement(PsiStatement body2) {
        if (!(body2 instanceof PsiBlockStatement)) {
            return body2;
        }
        PsiBlockStatement block = (PsiBlockStatement)body2;
        PsiCodeBlock codeBlock = block.getCodeBlock();
        return ControlFlowUtils.getFirstStatementInBlock(codeBlock);
    }

    @NotNull
    private static String getVariableReferenceText(PsiReferenceExpression reference, PsiVariable variable, PsiElement context) {
        String text2 = reference.getText();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)context.getProject());
        PsiExpression qualifier = reference.getQualifierExpression();
        while (qualifier != null) {
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return text2;
            }
            qualifier = ((PsiReferenceExpression)qualifier).getQualifierExpression();
        }
        PsiVariable target = resolveHelper.resolveReferencedVariable(text2, context);
        return variable != target ? ExpressionUtils.getQualifierOrThis(reference).getText() + "." + text2 : text2;
    }

    private class ForCanBeForeachFix
    extends InspectionGadgetsFix {
        private ForCanBeForeachFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            String newExpression;
            PsiElement forElement = descriptor.getPsiElement();
            PsiElement parent = forElement.getParent();
            if (!(parent instanceof PsiForStatement)) {
                return;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (ForCanBeForeachInspection.isArrayLoopStatement(forStatement)) {
                newExpression = this.createArrayIterationText(forStatement);
            } else if (ForCanBeForeachInspection.isCollectionLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                newExpression = this.createCollectionIterationText(forStatement);
            } else if (ForCanBeForeachInspection.isIndexedListLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                newExpression = this.createListIterationText(forStatement);
            } else {
                return;
            }
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)forStatement, newExpression);
        }

        @Nullable
        private String createListIterationText(@NotNull PsiForStatement forStatement) {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiVariable listVariable;
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            PsiExpression collectionSize;
            String indexName;
            PsiBinaryExpression condition2 = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(forStatement.getCondition());
            if (condition2 == null) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(condition2.getLOperand());
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(condition2.getROperand());
            if (rhs == null) {
                return null;
            }
            IElementType tokenType = condition2.getOperationTokenType();
            if (JavaTokenType.LT.equals(tokenType)) {
                indexName = lhs.getText();
                collectionSize = rhs;
            } else if (JavaTokenType.GT.equals(tokenType)) {
                indexName = rhs.getText();
                collectionSize = lhs;
            } else {
                return null;
            }
            if (collectionSize instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)collectionSize).resolve()) instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)target;
                collectionSize = ParenthesesUtils.stripParentheses(variable.getInitializer());
            }
            if (!(collectionSize instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(collectionSize);
            if (methodCallExpression == null) {
                return null;
            }
            PsiReferenceExpression listLengthExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(ExpressionUtils.getQualifierOrThis(listLengthExpression));
            PsiReferenceExpression listReference = qualifier instanceof PsiReferenceExpression ? (PsiReferenceExpression)qualifier : null;
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return null;
            }
            PsiType parameterType = ForCanBeForeachInspection.getContentType(type2, "java.util.Collection");
            if (parameterType == null) {
                parameterType = TypeUtils.getObjectType((PsiElement)forStatement);
            }
            if (listReference == null) {
                listVariable = null;
            } else {
                PsiElement target2 = listReference.resolve();
                if (!(target2 instanceof PsiVariable)) {
                    return null;
                }
                listVariable = (PsiVariable)target2;
            }
            PsiStatement body2 = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            boolean isDeclaration = this.isListElementDeclaration(firstStatement, listVariable, indexName, parameterType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                contentVariableName = variable.getName();
                parameterType = variable.getType();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                String collectionName = listReference == null ? null : listReference.getReferenceName();
                contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, parameterType, collectionName);
                finalString = "";
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder("for(");
            out.append(finalString).append(parameterType.getCanonicalText()).append(' ').append(contentVariableName).append(": ");
            String listName = listReference == null ? qualifier.getText() : ForCanBeForeachInspection.getVariableReferenceText(listReference, listVariable, (PsiElement)forStatement);
            out.append(listName).append(')');
            if (body2 != null) {
                this.replaceCollectionGetAccess((PsiElement)body2, contentVariableName, listVariable, indexName, (PsiElement)statementToSkip, out);
            }
            return out.toString();
        }

        @Nullable
        private String createCollectionIterationText(@NotNull PsiForStatement forStatement) {
            String finalString;
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiStatement body2 = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            PsiElement declaredIterator = declaration2.getDeclaredElements()[0];
            if (!(declaredIterator instanceof PsiVariable)) {
                return null;
            }
            PsiVariable iterator = (PsiVariable)declaredIterator;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)iterator.getInitializer();
            if (initializer == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = ExpressionUtils.getQualifierOrThis(methodExpression);
            PsiType collectionType = collection.getType();
            if (collectionType == null) {
                return null;
            }
            PsiType contentType = ForCanBeForeachInspection.getContentType(collectionType, "java.lang.Iterable");
            if (contentType == null) {
                return null;
            }
            PsiType iteratorContentType = ForCanBeForeachInspection.getContentType(iterator.getType(), "java.util.Iterator");
            if (TypeUtils.isJavaLangObject(iteratorContentType)) {
                iteratorContentType = ForCanBeForeachInspection.getContentType(initializer.getType(), "java.util.Iterator");
            }
            if (iteratorContentType == null) {
                return null;
            }
            boolean isDeclaration = ForCanBeForeachInspection.isIteratorNextDeclaration(firstStatement, iterator, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                iteratorContentType = variable.getType();
                contentVariableName = variable.getName();
                statementToSkip = declarationStatement;
                finalString = variable.hasModifierProperty("final") ? "final " : "";
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)collection;
                    String collectionName = referenceExpression.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, contentType, collectionName);
                } else {
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, contentType, null);
                }
                finalString = JavaCodeStyleSettings.getInstance((PsiFile)forStatement.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "";
                statementToSkip = null;
            }
            String contentTypeString = iteratorContentType.getCanonicalText();
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(contentTypeString);
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            if (!TypeConversionUtil.isAssignable((PsiType)iteratorContentType, (PsiType)contentType)) {
                out.append('(').append("java.lang.Iterable<").append(contentTypeString).append('>').append(')');
            }
            out.append(collection.getText());
            out.append(')');
            ForCanBeForeachInspection.replaceIteratorNext((PsiElement)body2, contentVariableName, iterator, contentType, (PsiElement)statementToSkip, out);
            return out.toString();
        }

        @Nullable
        private String createArrayIterationText(@NotNull PsiForStatement forStatement) {
            PsiDeclarationStatement statementToSkip;
            String finalString;
            String contentVariableName;
            PsiType type2;
            String indexName;
            PsiReferenceExpression arrayLengthExpression;
            PsiExpression condition2 = forStatement.getCondition();
            PsiBinaryExpression strippedCondition = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(condition2);
            if (strippedCondition == null) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(strippedCondition.getLOperand());
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(strippedCondition.getROperand());
            if (rhs == null) {
                return null;
            }
            IElementType tokenType = strippedCondition.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.LT)) {
                arrayLengthExpression = (PsiReferenceExpression)ParenthesesUtils.stripParentheses(rhs);
                indexName = lhs.getText();
            } else if (tokenType.equals(JavaTokenType.GT)) {
                arrayLengthExpression = (PsiReferenceExpression)ParenthesesUtils.stripParentheses(lhs);
                indexName = rhs.getText();
            } else {
                return null;
            }
            if (arrayLengthExpression == null) {
                return null;
            }
            PsiReferenceExpression arrayReference = (PsiReferenceExpression)arrayLengthExpression.getQualifierExpression();
            if (arrayReference == null) {
                PsiElement target = arrayLengthExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)target;
                PsiExpression initializer = variable.getInitializer();
                if (!(initializer instanceof PsiReferenceExpression)) {
                    return null;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)initializer;
                arrayReference = (PsiReferenceExpression)referenceExpression.getQualifierExpression();
                if (arrayReference == null) {
                    return null;
                }
            }
            if (!((type2 = arrayReference.getType()) instanceof PsiArrayType)) {
                return null;
            }
            PsiArrayType arrayType = (PsiArrayType)type2;
            PsiType componentType = arrayType.getComponentType();
            PsiElement target = arrayReference.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            PsiVariable arrayVariable = (PsiVariable)target;
            PsiStatement body2 = forStatement.getBody();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            boolean isDeclaration = this.isArrayElementDeclaration(firstStatement, arrayVariable, indexName);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable = (PsiVariable)declaredElement;
                componentType = variable.getType();
                if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)forStatement)) {
                    String collectionName = arrayReference.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, componentType, collectionName);
                    finalString = JavaCodeStyleSettings.getInstance((PsiFile)forStatement.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "";
                    statementToSkip = null;
                } else {
                    contentVariableName = variable.getName();
                    statementToSkip = declarationStatement;
                    finalString = variable.hasModifierProperty("final") ? "final " : "";
                }
            } else {
                String collectionName = arrayReference.getReferenceName();
                contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)forStatement, componentType, collectionName);
                finalString = JavaCodeStyleSettings.getInstance((PsiFile)forStatement.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "";
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            out.append(finalString);
            out.append(componentType.getCanonicalText());
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            String arrayName = ForCanBeForeachInspection.getVariableReferenceText(arrayReference, arrayVariable, (PsiElement)forStatement);
            out.append(arrayName);
            out.append(')');
            if (body2 != null) {
                this.replaceArrayAccess((PsiElement)body2, contentVariableName, arrayVariable, indexName, (PsiElement)statementToSkip, out);
            }
            return out.toString();
        }

        private void replaceArrayAccess(PsiElement element, String contentVariableName, PsiVariable arrayVariable, String indexName, PsiElement childToSkip, StringBuilder out) {
            if (this.isArrayLookup(element, indexName, arrayVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    String text2 = element.getText();
                    if ("instanceof".equals(text2) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(text2);
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        this.replaceArrayAccess(child, contentVariableName, arrayVariable, indexName, childToSkip, out);
                    }
                }
            }
        }

        private void replaceCollectionGetAccess(PsiElement element, String contentVariableName, PsiVariable listVariable, String indexName, PsiElement childToSkip, StringBuilder out) {
            if (this.isListGetLookup(element, indexName, listVariable)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    String text2 = element.getText();
                    if ("instanceof".equals(text2) && out.charAt(out.length() - 1) != ' ') {
                        out.append(' ');
                    }
                    out.append(text2);
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        this.replaceCollectionGetAccess(child, contentVariableName, listVariable, indexName, childToSkip, out);
                    }
                }
            }
        }

        private boolean isListGetLookup(PsiElement element, String indexName, PsiVariable listVariable) {
            if (!(element instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expression2 = (PsiExpression)element;
            if (!ForCanBeForeachInspection.expressionIsListGetLookup(expression2)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(expression2);
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 1) {
                return false;
            }
            if (!indexName.equals(expressions2[0].getText())) {
                return false;
            }
            if (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
                return listVariable == null;
            }
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return listVariable.equals(target);
        }

        private boolean isArrayElementDeclaration(PsiStatement statement, PsiVariable arrayVariable, String indexName) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            return this.isArrayLookup((PsiElement)initializer, indexName, arrayVariable);
        }

        private boolean isListElementDeclaration(PsiStatement statement, PsiVariable listVariable, String indexName, PsiType type2) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            return this.isListGetLookup((PsiElement)initializer, indexName, listVariable);
        }

        private boolean isArrayLookup(PsiElement element, String indexName, PsiVariable arrayVariable) {
            if (element == null) {
                return false;
            }
            if (!(element instanceof PsiArrayAccessExpression)) {
                return false;
            }
            PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)element;
            PsiExpression indexExpression = arrayAccess.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            if (!indexName.equals(indexExpression.getText())) {
                return false;
            }
            PsiExpression arrayExpression = arrayAccess.getArrayExpression();
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            return arrayVariable.equals(target);
        }
    }

    private class ForCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private ForCanBeForeachVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement forStatement) {
            super.visitForStatement(forStatement);
            if (ForCanBeForeachInspection.isArrayLoopStatement(forStatement) || ForCanBeForeachInspection.isCollectionLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections) || ForCanBeForeachInspection.this.REPORT_INDEXED_LOOP && ForCanBeForeachInspection.isIndexedListLoopStatement(forStatement, ForCanBeForeachInspection.this.ignoreUntypedCollections)) {
                this.registerStatementError((PsiStatement)forStatement, new Object[0]);
            }
        }
    }

    private static class Holder {
        public static final Holder DUMMY = new Holder();
        private final PsiVariable variable;

        Holder(@NotNull PsiVariable variable) {
            this.variable = variable;
        }

        private Holder() {
            this.variable = null;
        }

        public PsiVariable getVariable() {
            return this.variable;
        }
    }

    private static class VariableOnlyUsedAsListIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex = true;
        private boolean listGetCalled;
        private final PsiVariable indexVariable;
        private final Holder collection;

        private VariableOnlyUsedAsListIndexVisitor(@NotNull Holder collection, @NotNull PsiVariable indexVariable) {
            this.collection = collection;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (this.indexVariable.equals(element)) {
                if (!this.isListIndexExpression(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                } else {
                    this.listGetCalled = true;
                }
            } else if (this.collection == Holder.DUMMY) {
                if (this.isListNonGetMethodCall(reference)) {
                    this.indexVariableUsedOnlyAsIndex = false;
                }
            } else if (this.collection.getVariable().equals(element) && !this.isListReferenceInIndexExpression(reference)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex && this.listGetCalled;
        }

        private boolean isListNonGetMethodCall(PsiReferenceExpression reference) {
            PsiClass containingClass;
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)(containingClass = method.getContainingClass()), (boolean)true)) {
                return false;
            }
            return !this.isListGetExpression(methodCallExpression);
        }

        private boolean isListIndexExpression(PsiReferenceExpression reference) {
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)referenceParent;
            PsiElement parent = expressionList.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListReferenceInIndexExpression(PsiReferenceExpression reference) {
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiElement greatGrandParent = methodCallExpression.getParent();
            if (greatGrandParent instanceof PsiExpressionStatement) {
                return false;
            }
            return this.isListGetExpression(methodCallExpression);
        }

        private boolean isListGetExpression(PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                if (this.collection == Holder.DUMMY && (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression)) {
                    return ForCanBeForeachInspection.expressionIsListGetLookup((PsiExpression)methodCallExpression);
                }
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)qualifierExpression2;
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (this.collection == Holder.DUMMY || !this.collection.getVariable().equals(target)) {
                return false;
            }
            return ForCanBeForeachInspection.expressionIsListGetLookup((PsiExpression)methodCallExpression);
        }
    }

    private static class VariableOnlyUsedAsIndexVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean indexVariableUsedOnlyAsIndex = true;
        private boolean arrayAccessed = false;
        private final PsiVariable arrayVariable;
        private final PsiVariable indexVariable;

        private VariableOnlyUsedAsIndexVisitor(PsiVariable arrayVariable, PsiVariable indexVariable) {
            this.arrayVariable = arrayVariable;
            this.indexVariable = indexVariable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.indexVariableUsedOnlyAsIndex) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
            PsiAssignmentExpression assignment;
            PsiExpression lhs;
            if (!this.indexVariableUsedOnlyAsIndex) {
                return;
            }
            super.visitReferenceExpression(reference);
            PsiElement element = reference.resolve();
            if (!this.indexVariable.equals(element)) {
                return;
            }
            PsiElement parent = reference.getParent();
            if (!(parent instanceof PsiArrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (!(arrayExpression instanceof PsiReferenceExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (!this.arrayVariable.equals(target)) {
                this.indexVariableUsedOnlyAsIndex = false;
                return;
            }
            this.arrayAccessed = true;
            PsiElement arrayExpressionContext = arrayAccessExpression.getParent();
            if (arrayExpressionContext instanceof PsiAssignmentExpression && (lhs = (assignment = (PsiAssignmentExpression)arrayExpressionContext).getLExpression()).equals(arrayAccessExpression)) {
                this.indexVariableUsedOnlyAsIndex = false;
            }
        }

        private boolean isIndexVariableUsedOnlyAsIndex() {
            return this.indexVariableUsedOnlyAsIndex && this.arrayAccessed;
        }
    }

    private static class IteratorMethodCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean methodCalled;
        private final PsiVariable iterator;

        private IteratorMethodCallVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (!this.methodCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (this.methodCalled) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if ("next".equals(name)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.methodCalled = true;
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (this.methodCalled) {
                return;
            }
            super.visitMethodReferenceExpression(expression2);
            PsiExpression qualifierExpression2 = ParenthesesUtils.stripParentheses(expression2.getQualifierExpression());
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            if (this.iterator.equals(referenceExpression.resolve())) {
                this.methodCalled = true;
            }
        }

        private boolean isMethodCalled() {
            return this.methodCalled;
        }
    }

    private static class NumCallsToIteratorNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int numCallsToIteratorNext;
        private final PsiVariable iterator;

        private NumCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.iterator.equals(target)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        private int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }
    }
}

