/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FinalUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryFinallyCanBeTryWithResourcesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TryFinallyCanBeTryWithResourcesFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryFinallyCanBeTryWithResourcesVisitor();
    }

    private static List<PsiStatement> collectStatementsBetween(PsiStatement startExclusive, PsiStatement endExclusive) {
        ArrayList<PsiStatement> statements = new ArrayList<PsiStatement>();
        PsiStatement current = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)startExclusive, PsiStatement.class);
        while (current != endExclusive && current != null) {
            statements.add(current);
            current = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)current.getNextSibling(), PsiStatement.class);
        }
        return statements;
    }

    private static boolean resourceVariablesUsedInFinally(PsiStatement[] statements, BitSet closedVariableStatementIndices, Set<PsiVariable> resourceVariables2) {
        for (int i = 0; i < statements.length; ++i) {
            if (closedVariableStatementIndices.get(i)) continue;
            Set<PsiVariable> usedVariables = VariableAccessUtils.collectUsedVariables((PsiElement)statements[i]);
            for (PsiVariable usedVariable : usedVariables) {
                if (!resourceVariables2.contains(usedVariable)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean resourceVariableUsedInCatches(PsiTryStatement tryStatement, Set<PsiVariable> collectedVariables) {
        for (PsiCatchSection catchSection : tryStatement.getCatchSections()) {
            for (PsiVariable variable : collectedVariables) {
                if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)catchSection)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVariableUsedOutsideContext(PsiVariable variable, PsiElement context) {
        VariableUsedOutsideContextVisitor visitor = new VariableUsedOutsideContextVisitor(variable, context);
        PsiElement declarationScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (declarationScope == null) {
            return true;
        }
        declarationScope.accept((PsiElementVisitor)visitor);
        return visitor.variableIsUsed();
    }

    private static boolean findAutoClosableVariableWithoutTry(PsiStatement statement, Set<? super PsiVariable> variables) {
        if (statement instanceof PsiIfStatement) {
            PsiVariable resourceVariable;
            PsiLocalVariable variable;
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            if (ifStatement.getElseBranch() != null) {
                return false;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (!(condition2 instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            if (PsiType.NULL.equals((Object)rhs.getType())) {
                variable = ExpressionUtils.resolveLocalVariable(lhs);
            } else if (PsiType.NULL.equals((Object)lhs.getType())) {
                variable = ExpressionUtils.resolveLocalVariable(rhs);
            } else {
                return false;
            }
            if (variable == null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch instanceof PsiExpressionStatement) {
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(thenBranch);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(ControlFlowUtils.getOnlyStatementInBlock(codeBlock));
            } else {
                return false;
            }
            if (variable.equals(resourceVariable)) {
                variables.add((PsiVariable)resourceVariable);
                return true;
            }
        } else if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("close".equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable) && !(target instanceof PsiParameter) || target instanceof PsiResourceVariable) {
                    return false;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!TryFinallyCanBeTryWithResourcesInspection.isAutoCloseable(variable)) {
                    return false;
                }
                variables.add((PsiVariable)variable);
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    private static PsiVariable findAutoCloseableVariable(PsiStatement statement) {
        HashSet variables = new HashSet(1);
        if (!TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariables(statement, variables)) {
            return null;
        }
        if (variables.isEmpty()) {
            return null;
        }
        return (PsiVariable)ContainerUtil.getFirstItem(variables);
    }

    private static boolean findAutoCloseableVariables(PsiStatement statement, Set<? super PsiVariable> variables) {
        if (TryFinallyCanBeTryWithResourcesInspection.findAutoClosableVariableWithoutTry(statement, variables)) {
            return true;
        }
        if (statement instanceof PsiTryStatement) {
            PsiStatement[] tryStatements;
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            if (tryStatement.getResourceList() != null || tryStatement.getFinallyBlock() != null) {
                return true;
            }
            PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
            if (catchBlocks.length != 1) {
                return true;
            }
            PsiStatement[] catchStatements = catchBlocks[0].getStatements();
            if (catchStatements.length != 0) {
                return true;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return true;
            }
            for (PsiStatement tryStmt : tryStatements = tryBlock.getStatements()) {
                if (TryFinallyCanBeTryWithResourcesInspection.findAutoClosableVariableWithoutTry(tryStmt, variables)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAutoCloseable(PsiVariable variable) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType());
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.AutoCloseable");
    }

    private static int findInitialization(PsiElement[] elements, PsiVariable variable) {
        int result = -1;
        int statementsLength = elements.length;
        for (int i = 0; i < statementsLength; ++i) {
            PsiElement element = elements[i];
            if (TryFinallyCanBeTryWithResourcesInspection.isAssignmentToVariable(element, variable)) {
                if (result >= 0) {
                    return -1;
                }
                result = i;
                continue;
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, element)) continue;
            return -1;
        }
        return result;
    }

    private static boolean isAssignmentToVariable(PsiElement element, PsiVariable variable) {
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element, PsiExpressionStatement.class);
        if (expressionStatement == null) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiAssignmentExpression.class);
        if (assignmentExpression == null) {
            return false;
        }
        if (assignmentExpression.getRExpression() == null) {
            return false;
        }
        return ExpressionUtils.isReferenceTo(assignmentExpression.getLExpression(), variable);
    }

    private static class VariableUsedOutsideContextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean used;
        @NotNull
        private final PsiVariable variable;
        private final PsiElement skipContext;

        VariableUsedOutsideContextVisitor(@NotNull PsiVariable variable, PsiElement skipContext) {
            this.variable = variable;
            this.skipContext = skipContext;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element.equals(this.skipContext)) {
                return;
            }
            if (this.used) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(referenceExpression);
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            if (target.equals(this.variable) && !VariableUsedOutsideContextVisitor.isCloseMethodCalled(referenceExpression)) {
                this.used = true;
            }
        }

        private static boolean isCloseMethodCalled(PsiReferenceExpression referenceExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (!argumentList.isEmpty()) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            return "close".equals(name);
        }

        public boolean variableIsUsed() {
            return this.used;
        }
    }

    private static class ResourceVariable {
        @Nullable(value="when in java 9")
        final PsiExpression myInitializer;
        final boolean myUsedOutsideTry;
        @NotNull
        final PsiVariable myVariable;

        ResourceVariable(@Nullable PsiExpression initializer, boolean usedOutsideTry, @NotNull PsiVariable variable) {
            this.myInitializer = initializer;
            this.myUsedOutsideTry = usedOutsideTry;
            this.myVariable = variable;
        }

        String generateResourceDeclaration() {
            if (this.myUsedOutsideTry) {
                return this.myVariable.getName();
            }
            assert (this.myInitializer != null);
            return Objects.requireNonNull(this.myVariable.getTypeElement()).getText() + " " + this.myVariable.getName() + "=" + this.myInitializer.getText();
        }

        PsiElement getInitializedElement() {
            if (this.myInitializer != null) {
                return this.myInitializer;
            }
            return this.myVariable;
        }
    }

    private static class Context {
        @NotNull
        final List<ResourceVariable> myResourceVariables;
        @NotNull
        final Set<PsiStatement> myStatementsToDelete;

        private Context(@NotNull List<ResourceVariable> resourceVariables2, @NotNull Set<PsiStatement> statementsToDelete) {
            this.myResourceVariables = resourceVariables2;
            this.myStatementsToDelete = statementsToDelete;
        }

        @Nullable
        static Context from(@NotNull PsiTryStatement tryStatement) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return null;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return null;
            }
            PsiStatement[] tryStatements = tryBlock.getStatements();
            PsiStatement[] finallyStatements = finallyBlock.getStatements();
            BitSet closedVariableStatementIndices = new BitSet(finallyStatements.length);
            HashSet<PsiVariable> collectedVariables = new HashSet<PsiVariable>();
            int length = finallyStatements.length;
            for (int i = 0; i < length; ++i) {
                PsiStatement statement = finallyStatements[i];
                closedVariableStatementIndices.set(i, TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariables(statement, collectedVariables));
            }
            if (collectedVariables.isEmpty()) {
                return null;
            }
            if (TryFinallyCanBeTryWithResourcesInspection.resourceVariablesUsedInFinally(finallyStatements, closedVariableStatementIndices, collectedVariables)) {
                return null;
            }
            if (TryFinallyCanBeTryWithResourcesInspection.resourceVariableUsedInCatches(tryStatement, collectedVariables)) {
                return null;
            }
            ArrayList<ResourceVariable> resourceVariables2 = new ArrayList<ResourceVariable>();
            ArrayList<PsiStatement> statementsToDelete = new ArrayList<PsiStatement>();
            TIntArrayList initializerPositions = new TIntArrayList();
            for (PsiVariable resourceVariable : collectedVariables) {
                boolean variableUsedOutsideTry = TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext(resourceVariable, (PsiElement)tryStatement);
                if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)finallyBlock) && variableUsedOutsideTry) {
                    return null;
                }
                if (!variableUsedOutsideTry && resourceVariable instanceof PsiLocalVariable) {
                    boolean hasNonNullInitializer;
                    PsiExpression initializer = resourceVariable.getInitializer();
                    boolean bl = hasNonNullInitializer = initializer != null && !PsiType.NULL.equals((Object)initializer.getType());
                    if (!hasNonNullInitializer) {
                        int assignmentStatementIndex = TryFinallyCanBeTryWithResourcesInspection.findInitialization((PsiElement[])tryStatements, resourceVariable);
                        if (assignmentStatementIndex == -1) {
                            return null;
                        }
                        initializerPositions.add(assignmentStatementIndex);
                        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)tryStatements[assignmentStatementIndex];
                        PsiExpression expression2 = assignmentStatement.getExpression();
                        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expression2, PsiAssignmentExpression.class);
                        if (assignment == null) {
                            return null;
                        }
                        initializer = assignment.getRExpression();
                        if (initializer == null) {
                            return null;
                        }
                        statementsToDelete.add(tryStatements[assignmentStatementIndex]);
                    } else if (VariableAccessUtils.variableIsAssigned(resourceVariable, (PsiElement)tryBlock)) {
                        return null;
                    }
                    resourceVariables2.add(new ResourceVariable(initializer, false, resourceVariable));
                    continue;
                }
                if ((resourceVariable instanceof PsiLocalVariable && resourceVariable.getInitializer() != null || resourceVariable instanceof PsiParameter) && FinalUtils.canBeFinal(resourceVariable)) {
                    resourceVariables2.add(new ResourceVariable(null, true, resourceVariable));
                    continue;
                }
                return null;
            }
            for (int i = 0; i < finallyStatements.length; ++i) {
                if (!closedVariableStatementIndices.get(i)) continue;
                statementsToDelete.add(finallyStatements[i]);
            }
            if (!Context.noStatementsBetweenVariableDeclarations(collectedVariables)) {
                return null;
            }
            if (!Context.initializersAreAtTheBeginning(initializerPositions)) {
                return null;
            }
            Collections.sort(resourceVariables2, Comparator.comparing(o -> o.getInitializedElement(), PsiElementOrderComparator.getInstance()));
            return new Context(resourceVariables2, new HashSet<PsiStatement>(statementsToDelete));
        }

        private static boolean initializersAreAtTheBeginning(TIntArrayList initializerPositions) {
            initializerPositions.sort();
            for (int i = 0; i < initializerPositions.size(); ++i) {
                if (initializerPositions.get(i) == i) continue;
                return false;
            }
            return true;
        }

        private static boolean noStatementsBetweenVariableDeclarations(Set<PsiVariable> collectedVariables) {
            return ((StreamEx)StreamEx.of(collectedVariables).select(PsiLocalVariable.class).sorted((Comparator)PsiElementOrderComparator.getInstance())).map(var -> (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)var, PsiStatement.class)).pairMap((l1, l2) -> l1 != null && l2 != null && l1.getParent() == l2.getParent() && TryFinallyCanBeTryWithResourcesInspection.collectStatementsBetween(l1, l2).isEmpty()).allMatch(b -> b);
        }
    }

    private static class TryFinallyCanBeTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private TryFinallyCanBeTryWithResourcesVisitor() {
        }

        public void visitTryStatement(PsiTryStatement tryStatement) {
            super.visitTryStatement(tryStatement);
            if (Context.from(tryStatement) == null) {
                return;
            }
            this.registerStatementError((PsiStatement)tryStatement, new Object[0]);
        }
    }

    private static class TryFinallyCanBeTryWithResourcesFix
    extends InspectionGadgetsFix {
        private TryFinallyCanBeTryWithResourcesFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.quickfix", new Object[0]);
        }

        private static <T> Pair<List<T>, List<T>> partition(Iterable<T> iterable, Predicate<T> predicate) {
            SmartList list1 = new SmartList();
            SmartList list2 = new SmartList();
            for (T value2 : iterable) {
                if (predicate.test(value2)) {
                    list1.add(value2);
                    continue;
                }
                list2.add(value2);
            }
            return new Pair((Object)list1, (Object)list2);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement[] children;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Context context = Context.from(tryStatement);
            if (context == null) {
                return;
            }
            Pair<List<ResourceVariable>, List<ResourceVariable>> partition = TryFinallyCanBeTryWithResourcesFix.partition(context.myResourceVariables, variable -> variable.getInitializedElement().getTextOffset() < tryStatement.getTextOffset());
            List before = (List)partition.first;
            List after = (List)partition.second;
            String resourceListBefore = this.joinToString(before);
            String resourceListAfter = this.joinToString(after);
            StringBuilder sb = new StringBuilder("try(");
            PsiResourceList resourceListElement = tryStatement.getResourceList();
            if (!before.isEmpty()) {
                sb.append(resourceListBefore);
                if (resourceListElement != null || !after.isEmpty()) {
                    sb.append(";");
                }
            }
            if (resourceListElement != null && (children = resourceListElement.getChildren()).length > 2 && resourceListElement.getResourceVariablesCount() > 0) {
                for (int i = 1; i < children.length - 1; ++i) {
                    sb.append(children[i].getText());
                }
            }
            if (!after.isEmpty()) {
                if (!before.isEmpty() || resourceListElement != null) {
                    sb.append(";");
                }
                sb.append(resourceListAfter);
            }
            sb.append(")");
            List locals = ((StreamEx)StreamEx.of(context.myResourceVariables).map(resourceVariable -> resourceVariable.myVariable).select(PsiLocalVariable.class).sorted((Comparator)PsiElementOrderComparator.getInstance())).toList();
            if (locals.size() == 1) {
                PsiLocalVariable variable2 = (PsiLocalVariable)locals.get(0);
                PsiStatement declaration2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiStatement.class);
                if (declaration2 == null) {
                    return;
                }
                if (declaration2.getParent() != tryStatement.getParent()) {
                    return;
                }
                List statements = TryFinallyCanBeTryWithResourcesInspection.collectStatementsBetween(declaration2, (PsiStatement)tryStatement);
                PsiJavaToken psiJavaToken = tryBlock.getLBrace();
                if (psiJavaToken != null) {
                    for (int i = statements.size() - 1; i >= 0; --i) {
                        PsiStatement statement = (PsiStatement)statements.get(i);
                        tryBlock.addAfter((PsiElement)statement, (PsiElement)psiJavaToken);
                        if (!statement.isValid()) continue;
                        statement.delete();
                    }
                }
            }
            TryFinallyCanBeTryWithResourcesFix.restoreStatementsBeforeLastVariableInTryResource(tryStatement, tryBlock, context);
            for (PsiStatement statement : context.myStatementsToDelete) {
                if (!statement.isValid()) continue;
                new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
            }
            for (ResourceVariable variable3 : context.myResourceVariables) {
                if (variable3.myUsedOutsideTry || !variable3.myVariable.isValid()) continue;
                new CommentTracker().deleteAndRestoreComments((PsiElement)variable3.myVariable);
            }
            sb.append(tryBlock.getText());
            for (Iterator<Object> iterator : tryStatement.getCatchSections()) {
                sb.append(iterator.getText());
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            if (!ControlFlowUtils.isEmptyCodeBlock(finallyBlock)) {
                sb.append("finally").append(finallyBlock.getText());
            } else {
                Object[] finallyBlockChildren = finallyBlock.getChildren();
                if (!((StreamEx)((StreamEx)StreamEx.of((Object[])finallyBlockChildren).skip(1L)).limit((long)(finallyBlockChildren.length - 2))).allMatch(el -> el instanceof PsiWhiteSpace)) {
                    PsiElement tryParent = tryStatement.getParent();
                    tryParent.addRangeAfter((PsiElement)finallyBlockChildren[1], (PsiElement)finallyBlockChildren[finallyBlockChildren.length - 2], (PsiElement)tryStatement);
                }
            }
            tryStatement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(sb.toString(), (PsiElement)tryStatement));
        }

        private String joinToString(List<ResourceVariable> variables) {
            return variables.stream().map(ResourceVariable::generateResourceDeclaration).collect(Collectors.joining("; "));
        }

        private static void restoreStatementsBeforeLastVariableInTryResource(PsiTryStatement tryStatement, PsiCodeBlock tryBlock, Context context) {
            Optional lastInTryVariable = ((StreamEx)StreamEx.of(context.myResourceVariables).map(v -> v.myInitializer).filter(e -> e != null && PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)e, (boolean)false))).max((Comparator)PsiElementOrderComparator.getInstance());
            ArrayList<PsiStatement> elementsToRestore = new ArrayList<PsiStatement>();
            if (lastInTryVariable.isPresent()) {
                PsiStatement last = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)lastInTryVariable.get()), PsiStatement.class);
                PsiStatement[] statements = tryBlock.getStatements();
                for (int i = 0; i < statements.length && statements[i] != last; ++i) {
                    PsiStatement current = statements[i];
                    if (context.myStatementsToDelete.contains(current)) continue;
                    elementsToRestore.add(current);
                }
            }
            PsiElement tryStatementParent = tryStatement.getParent();
            for (PsiStatement statement : elementsToRestore) {
                tryStatementParent.addBefore((PsiElement)statement, (PsiElement)tryStatement);
                statement.delete();
            }
        }
    }
}

