/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryWithIdenticalCatchesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        return InspectionGadgetsBundle.message("try.with.identical.catches.problem.descriptor", type2.getPresentableText());
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("try.with.identical.catches.display.name", new Object[0]);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return JavaFeature.MULTI_CATCH.isFeatureSupported(file);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        PsiCatchSection catchSection;
        PsiParameter parameter2;
        if (element instanceof PsiCatchSection && (parameter2 = (catchSection = (PsiCatchSection)element).getParameter()) != null && super.isSuppressedFor((PsiElement)parameter2)) {
            return true;
        }
        return super.isSuppressedFor(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryWithIdenticalCatchesVisitor();
    }

    @Nullable
    static CatchSectionIndices[] getCatchSectionIndices(@NotNull CatchSectionWrapper[] sections, @NotNull boolean[][] canSwap, @NotNull BiPredicate<? super CatchSectionWrapper, ? super CatchSectionWrapper> equals) {
        CatchSectionIndices[] indices2 = new CatchSectionIndices[sections.length];
        for (int index = 0; index < sections.length; ++index) {
            indices2[index] = new CatchSectionIndices(index);
        }
        boolean duplicateFound = false;
        for (int from = 0; from < sections.length - 1; ++from) {
            CatchSectionWrapper section;
            if (indices2[from].myHasDuplicate || (section = sections[from]) == null) continue;
            for (int to = from + 1; to < sections.length; ++to) {
                CatchSectionWrapper otherSection;
                if (indices2[to].myHasDuplicate || (otherSection = sections[to]) == null || !equals.test(section, otherSection)) continue;
                indices2[from].addDuplicate(indices2[to]);
                duplicateFound = true;
            }
        }
        if (!duplicateFound) {
            return null;
        }
        for (int index = 0; index < sections.length; ++index) {
            indices2[index].computeInsertionRange(canSwap);
        }
        for (CatchSectionIndices idx : indices2) {
            int[] duplicates = idx.myDuplicates;
            if (duplicates == null) continue;
            for (int from : duplicates) {
                for (int to : duplicates) {
                    indices2[to].tryCollapseInto(indices2[from]);
                }
            }
        }
        return indices2;
    }

    private static boolean[][] collectCanSwap(@NotNull CatchSectionWrapper[] sections) {
        boolean[][] canSwap = new boolean[sections.length][sections.length];
        for (int from = 0; from < sections.length; ++from) {
            for (int to = from + 1; to < sections.length; ++to) {
                boolean bl = sections[from] != null && sections[from].canSwapWith(sections[to]);
                canSwap[to][from] = bl;
                canSwap[from][to] = bl;
            }
        }
        return canSwap;
    }

    public static void collectCommentTexts(@NotNull PsiElement element, @NotNull Collection<String> result) {
        if (element instanceof PsiComment) {
            TryWithIdenticalCatchesInspection.addCommentText(result, (PsiComment)element);
            return;
        }
        if (element instanceof LeafPsiElement) {
            return;
        }
        PsiTreeUtil.processElements((PsiElement)element, child -> {
            if (child instanceof PsiComment) {
                TryWithIdenticalCatchesInspection.addCommentText(result, (PsiComment)child);
            }
            return true;
        });
    }

    private static void addCommentText(@NotNull Collection<String> result, PsiComment child) {
        String text2 = TryWithIdenticalCatchesInspection.getCommentText(child);
        if (!text2.isEmpty()) {
            result.add(text2);
        }
    }

    @NotNull
    private static List<String> collectCommentTexts(@NotNull PsiElement element) {
        ArrayList<String> result = new ArrayList<String>();
        TryWithIdenticalCatchesInspection.collectCommentTexts(element, result);
        return result;
    }

    @NotNull
    public static String getCommentText(@NotNull PsiComment comment) {
        IElementType type2 = comment.getTokenType();
        String text2 = comment.getText();
        int start = 0;
        int end = text2.length();
        if (comment instanceof PsiDocComment) {
            if (text2.startsWith("/**")) {
                start += "/**".length();
            }
            if (text2.endsWith("*/")) {
                end -= "*/".length();
            }
        } else if (type2 == JavaTokenType.C_STYLE_COMMENT) {
            if (text2.startsWith("/*")) {
                start += "/*".length();
            }
            if (text2.endsWith("*/")) {
                end -= "*/".length();
            }
        } else if (type2 == JavaTokenType.END_OF_LINE_COMMENT && text2.startsWith("//")) {
            start += "//".length();
        }
        while (start < end && Character.isWhitespace(text2.charAt(start))) {
            ++start;
        }
        while (start < end - 1 && Character.isWhitespace(text2.charAt(end - 1))) {
            --end;
        }
        return start < end ? text2.substring(start, end) : "";
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseCatchSectionsFix((Boolean)infos[1]);
    }

    private static class CollapseCatchSectionsFix
    extends InspectionGadgetsFix {
        private final boolean myEmpty;

        CollapseCatchSectionsFix(boolean empty) {
            this.myEmpty = empty;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("try.with.identical.catches.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiCatchSection[] catchSections;
            PsiCatchSection catchSection = (PsiCatchSection)descriptor.getPsiElement();
            PsiTryStatement tryStatement = (PsiTryStatement)catchSection.getParent();
            CatchSectionWrapper[] sections = CatchSectionWrapper.createWrappers(tryStatement);
            if (sections == null) {
                return;
            }
            int sectionIndex = CollapseCatchSectionsFix.getSectionIndex(sections, (PsiElement)catchSection);
            if (sectionIndex < 0) {
                return;
            }
            CatchSectionWrapper duplicateSection = sections[sectionIndex];
            if (duplicateSection == null) {
                return;
            }
            boolean[][] canSwap = TryWithIdenticalCatchesInspection.collectCanSwap(sections);
            CatchSectionIndices[] duplicatesIndices = TryWithIdenticalCatchesInspection.getCatchSectionIndices(sections, canSwap, this.myEmpty ? CatchSectionWrapper::areEmpty : CatchSectionWrapper::areDuplicates);
            if (duplicatesIndices == null) {
                return;
            }
            int collapseIntoIndex = duplicatesIndices[sectionIndex].myCollapseIntoIndex;
            if (collapseIntoIndex < 0) {
                return;
            }
            CatchSectionWrapper collapseIntoSection = sections[collapseIntoIndex];
            if (collapseIntoSection == null) {
                return;
            }
            PsiTypeElement collapseIntoTypeElement = collapseIntoSection.myParameter.getTypeElement();
            if (collapseIntoTypeElement == null) {
                return;
            }
            HashSet survivingCommentTexts = new HashSet(TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)collapseIntoSection.myCatchSection));
            ArrayList<? extends PsiClassType> parameterTypes = new ArrayList<PsiClassType>(collapseIntoSection.myTypes);
            parameterTypes.addAll(duplicateSection.myTypes);
            List filteredTypes = PsiDisjunctionType.flattenAndRemoveDuplicates(parameterTypes);
            PsiType disjunction = PsiDisjunctionType.createDisjunction((List)filteredTypes, (PsiManager)tryStatement.getManager());
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElement(disjunction);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(collapseIntoTypeElement.replace((PsiElement)newTypeElement));
            int insertBeforeIndex = duplicatesIndices[sectionIndex].myCanInsertBefore;
            if (collapseIntoIndex < insertBeforeIndex && insertBeforeIndex < (catchSections = tryStatement.getCatchSections()).length && catchSections[insertBeforeIndex] != null) {
                tryStatement.addBefore((PsiElement)collapseIntoSection.myCatchSection, (PsiElement)catchSections[insertBeforeIndex]);
                collapseIntoSection.myCatchSection.delete();
            }
            CommentTracker tracker = new CommentTracker();
            PsiTreeUtil.processElements((PsiElement)duplicateSection.myCatchSection, element -> {
                String text2;
                if (element instanceof PsiComment && ((text2 = TryWithIdenticalCatchesInspection.getCommentText((PsiComment)element)).isEmpty() || survivingCommentTexts.contains(text2))) {
                    tracker.markUnchanged(element);
                }
                return true;
            });
            tracker.deleteAndRestoreComments((PsiElement)duplicateSection.myCatchSection);
        }

        private static int getSectionIndex(@NotNull CatchSectionWrapper[] sections, @NotNull PsiElement catchSection) {
            for (int i = 0; i < sections.length; ++i) {
                if (sections[i].myCatchSection != catchSection) continue;
                return i;
            }
            return -1;
        }
    }

    private static class CatchSectionWrapper {
        @NotNull
        final PsiCatchSection myCatchSection;
        @NotNull
        final PsiCodeBlock myCodeBlock;
        @NotNull
        final PsiParameter myParameter;
        @NotNull
        final List<? extends PsiClassType> myTypes;
        @NotNull
        final DuplicatesFinder myFinder;

        private CatchSectionWrapper(@NotNull PsiCatchSection catchSection, @NotNull PsiCodeBlock codeBlock, @NotNull PsiParameter parameter2, @NotNull List<? extends PsiClassType> types, @NotNull DuplicatesFinder finder) {
            this.myCatchSection = catchSection;
            this.myCodeBlock = codeBlock;
            this.myParameter = parameter2;
            this.myTypes = types;
            this.myFinder = finder;
        }

        static boolean areEmpty(@NotNull CatchSectionWrapper s1, @NotNull CatchSectionWrapper s2) {
            return s1.myCodeBlock.isEmpty() && s2.myCodeBlock.isEmpty();
        }

        static boolean areDuplicates(@NotNull CatchSectionWrapper s1, @NotNull CatchSectionWrapper s2) {
            boolean empty2;
            boolean empty1 = s1.myCodeBlock.isEmpty();
            if (empty1 != (empty2 = s2.myCodeBlock.isEmpty())) {
                return false;
            }
            if (empty1) {
                List comments1 = TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)s1.myCatchSection);
                List comments2 = TryWithIdenticalCatchesInspection.collectCommentTexts((PsiElement)s2.myCatchSection);
                return comments1.equals(comments2);
            }
            Match match1 = s1.findDuplicate(s2);
            if (match1 == null) {
                return false;
            }
            Match match2 = s2.findDuplicate(s1);
            if (match2 == null) {
                return false;
            }
            return ReturnValue.areEquivalent(match1.getReturnValue(), match2.getReturnValue());
        }

        private Match findDuplicate(@NotNull CatchSectionWrapper section) {
            return this.myFinder.isDuplicate((PsiElement)section.myCodeBlock, true);
        }

        boolean canSwapWith(@Nullable CatchSectionWrapper section) {
            if (section == null) {
                return false;
            }
            for (PsiClassType psiClassType : this.myTypes) {
                for (PsiClassType psiClassType2 : section.myTypes) {
                    if (!psiClassType.isAssignableFrom((PsiType)psiClassType2) && !psiClassType2.isAssignableFrom((PsiType)psiClassType)) continue;
                    return false;
                }
            }
            return true;
        }

        @Nullable
        static CatchSectionWrapper[] createWrappers(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections = statement.getCatchSections();
            if (catchSections.length < 2) {
                return null;
            }
            PsiParameter[] parameters2 = statement.getCatchBlockParameters();
            if (catchSections.length != parameters2.length) {
                return null;
            }
            CatchSectionWrapper[] sections = new CatchSectionWrapper[catchSections.length];
            for (int i = 0; i < sections.length; ++i) {
                sections[i] = CatchSectionWrapper.createWrapper(catchSections[i]);
            }
            return sections;
        }

        @Nullable
        private static CatchSectionWrapper createWrapper(@NotNull PsiCatchSection catchSection) {
            List<PsiClassType> types;
            PsiParameter parameter2 = catchSection.getParameter();
            PsiCodeBlock codeBlock = catchSection.getCatchBlock();
            if (parameter2 != null && codeBlock != null && (types = CatchSectionWrapper.getClassTypes(parameter2.getType())) != null) {
                DuplicatesFinder finder = CatchSectionWrapper.buildDuplicatesFinder(codeBlock, parameter2);
                return new CatchSectionWrapper(catchSection, codeBlock, parameter2, types, finder);
            }
            return null;
        }

        @Nullable
        private static List<PsiClassType> getClassTypes(@Nullable PsiType type2) {
            List classTypes;
            List disjunctions;
            if (type2 instanceof PsiClassType) {
                return Collections.singletonList((PsiClassType)type2);
            }
            if (type2 instanceof PsiDisjunctionType && !(disjunctions = ((PsiDisjunctionType)type2).getDisjunctions()).isEmpty() && (classTypes = ContainerUtil.mapNotNull((Collection)disjunctions, t -> (PsiClassType)ObjectUtils.tryCast((Object)t, PsiClassType.class))).size() == disjunctions.size()) {
                return classTypes;
            }
            return null;
        }

        @NotNull
        private static DuplicatesFinder buildDuplicatesFinder(@NotNull PsiCodeBlock catchBlock, @NotNull PsiParameter parameter2) {
            InputVariables inputVariables = new InputVariables(Collections.singletonList(parameter2), parameter2.getProject(), new LocalSearchScope((PsiElement)catchBlock), false);
            return new DuplicatesFinder(new PsiElement[]{catchBlock}, inputVariables, null, Collections.emptyList());
        }
    }

    private static class CatchSectionIndices {
        final int myIndex;
        int myCanInsertBefore = -1;
        int myCanInsertAfter = -1;
        boolean myHasDuplicate;
        int[] myDuplicates;
        int myCollapseIntoIndex = -1;

        CatchSectionIndices(int index) {
            this.myIndex = index;
        }

        void addDuplicate(CatchSectionIndices duplicate) {
            if (this.myDuplicates == null) {
                this.myDuplicates = new int[]{this.myIndex, duplicate.myIndex};
                this.myHasDuplicate = true;
            } else {
                this.myDuplicates = ArrayUtil.append((int[])this.myDuplicates, (int)duplicate.myIndex);
            }
            duplicate.myHasDuplicate = true;
        }

        void computeInsertionRange(@NotNull boolean[][] canSwap) {
            boolean[] canSwapWith = canSwap[this.myIndex];
            int before = this.myIndex;
            while (true) {
                if (before - 1 < 0 || !canSwapWith[before - 1]) break;
                --before;
            }
            this.myCanInsertBefore = before;
            int after = this.myIndex;
            while (true) {
                if (after + 1 >= canSwapWith.length || !canSwapWith[after + 1]) break;
                ++after;
            }
            this.myCanInsertAfter = after;
        }

        public void tryCollapseInto(CatchSectionIndices collapseInto) {
            if (this.myCollapseIntoIndex < 0 && this.myIndex > collapseInto.myIndex && this.myCanInsertBefore <= collapseInto.myCanInsertAfter + 1) {
                this.myCollapseIntoIndex = collapseInto.myIndex;
            }
        }
    }

    private static class TryWithIdenticalCatchesVisitor
    extends BaseInspectionVisitor {
        private TryWithIdenticalCatchesVisitor() {
        }

        public void visitTryStatement(PsiTryStatement statement) {
            CatchSectionIndices[] emptyIndices;
            super.visitTryStatement(statement);
            CatchSectionWrapper[] sections = CatchSectionWrapper.createWrappers(statement);
            if (sections == null) {
                return;
            }
            boolean[][] canSwap = TryWithIdenticalCatchesInspection.collectCanSwap(sections);
            CatchSectionIndices[] duplicateIndices = TryWithIdenticalCatchesInspection.getCatchSectionIndices(sections, canSwap, CatchSectionWrapper::areDuplicates);
            CatchSectionIndices[] catchSectionIndicesArray = emptyIndices = this.isOnTheFly() ? TryWithIdenticalCatchesInspection.getCatchSectionIndices(sections, canSwap, CatchSectionWrapper::areEmpty) : null;
            if (duplicateIndices == null && emptyIndices == null) {
                return;
            }
            boolean[] problems = new boolean[sections.length];
            this.registerProblems(sections, duplicateIndices, problems, false);
            this.registerProblems(sections, emptyIndices, problems, true);
        }

        private void registerProblems(@NotNull CatchSectionWrapper[] sections, @Nullable CatchSectionIndices[] sectionIndices, @NotNull boolean[] problems, boolean empty) {
            if (sectionIndices == null) {
                return;
            }
            for (int index = 0; index < sections.length; ++index) {
                int collapseIntoIndex;
                if (problems[index] || (collapseIntoIndex = sectionIndices[index].myCollapseIntoIndex) < 0) continue;
                this.registerProblem(sections, index, collapseIntoIndex, empty);
                problems[index] = true;
            }
        }

        private void registerProblem(@NotNull CatchSectionWrapper[] sections, int at, int collapseIntoIndex, boolean empty) {
            PsiCatchSection section = sections[at].myCatchSection;
            PsiJavaToken rParenth = section.getRParenth();
            if (rParenth != null) {
                this.registerErrorAtOffset((PsiElement)section, 0, rParenth.getStartOffsetInParent() + 1, empty ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{sections[collapseIntoIndex].myParameter.getType(), empty});
            }
        }
    }
}

