/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.modularization;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;

public class ClassOnlyUsedInOneModuleInspection
extends BaseGlobalInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.only.used.in.one.module.display.name", new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner = refClass.getOwner();
        if (!(owner instanceof RefPackage)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        RefModule otherModule = null;
        for (RefClass refClass2 : dependencies) {
            RefModule module = refClass2.getModule();
            if (refClass.getModule() == module) {
                return null;
            }
            if (otherModule == module) continue;
            if (otherModule == null) {
                otherModule = module;
                continue;
            }
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            RefModule module = dependent.getModule();
            if (refClass.getModule() == module) {
                return null;
            }
            if (otherModule == module) continue;
            if (otherModule == null) {
                otherModule = module;
                continue;
            }
            return null;
        }
        if (otherModule == null) {
            return null;
        }
        PsiElement psiElement = UDeclarationKt.getAnchorPsi((UDeclaration)refClass.getUastElement());
        if (psiElement == null) {
            return null;
        }
        String moduleName = otherModule.getName();
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor(psiElement, InspectionGadgetsBundle.message("class.only.used.in.one.module.problem.descriptor", moduleName), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }
}

