/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClassNameSameAsAncestorNameInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.name.same.as.ancestor.name.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("class.name.same.as.ancestor.name.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameSameAsAncestorNameVisitor();
    }

    private static class ClassNameSameAsAncestorNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameSameAsAncestorNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass[] supers;
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            HashSet alreadyVisited = new HashSet(8);
            for (PsiClass aSuper : supers = aClass.getSupers()) {
                if (!ClassNameSameAsAncestorNameVisitor.hasMatchingName(aSuper, className, alreadyVisited)) continue;
                this.registerClassError(aClass, new Object[0]);
            }
        }

        private static boolean hasMatchingName(PsiClass aSuper, String className, Set<? super PsiClass> alreadyVisited) {
            PsiClass[] supers;
            if (aSuper == null) {
                return false;
            }
            if (alreadyVisited.contains(aSuper)) {
                return false;
            }
            alreadyVisited.add((PsiClass)aSuper);
            String superName = aSuper.getName();
            if (className.equals(superName)) {
                return true;
            }
            for (PsiClass aSupers : supers = aSuper.getSupers()) {
                if (!ClassNameSameAsAncestorNameVisitor.hasMatchingName(aSupers, className, alreadyVisited)) continue;
                return true;
            }
            return false;
        }
    }
}

