/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ConfusingMainMethodInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("confusing.main.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("confusing.main.method.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingMainMethodVisitor();
    }

    private static class ConfusingMainMethodVisitor
    extends BaseInspectionVisitor {
        private ConfusingMainMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod aMethod) {
            String methodName = aMethod.getName();
            if (!"main".equals(methodName)) {
                return;
            }
            if (!aMethod.hasModifierProperty("public")) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            if (!aMethod.hasModifierProperty("static")) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            PsiType returnType = aMethod.getReturnType();
            if (!TypeUtils.typeEquals("void", returnType)) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            PsiParameterList parameterList = aMethod.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                this.registerMethodError(aMethod, new Object[0]);
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiType parameterType = parameters2[0].getType();
            if (!TypeUtils.typeEquals("java.lang.String[]", parameterType)) {
                this.registerMethodError(aMethod, new Object[0]);
            }
        }
    }
}

