/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ConventionInspection
extends BaseInspection {
    public static final JComponent[] EMPTY_JCOMPONENT_ARRAY = new JComponent[0];
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        String name = (String)infos[0];
        int length = name.length();
        if (length < this.getMinLength()) {
            return InspectionGadgetsBundle.message("naming.convention.problem.descriptor.short", this.getElementDescription(), length, this.getMinLength());
        }
        if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
            return InspectionGadgetsBundle.message("naming.convention.problem.descriptor.long", this.getElementDescription(), length, this.getMaxLength());
        }
        return InspectionGadgetsBundle.message("naming.convention.problem.descriptor.regex.mismatch", this.getElementDescription(), this.getRegex());
    }

    protected abstract String getElementDescription();

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        if ("serialVersionUID".equals(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    @NotNull
    public JComponent[] createExtraOptions() {
        return EMPTY_JCOMPONENT_ARRAY;
    }

    public final JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", this.createExtraOptions());
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }
}

