/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class ExceptionNameDoesntEndWithExceptionInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        return "ExceptionClassNameDoesntEndWithException";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("exception.name.doesnt.end.with.exception.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("exception.name.doesnt.end.with.exception.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExceptionNameDoesntEndWithExceptionVisitor();
    }

    private static class ExceptionNameDoesntEndWithExceptionVisitor
    extends BaseInspectionVisitor {
        private ExceptionNameDoesntEndWithExceptionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String exception = "Exception";
            if (className.endsWith("Exception")) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

