/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.fixes.RenameFix;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldNamingConventionInspection
extends AbstractNamingConventionInspection<PsiField> {
    public static final ExtensionPointName<NamingConvention<PsiField>> EP_NAME = ExtensionPointName.create((String)"com.intellij.naming.convention.field");

    public FieldNamingConventionInspection() {
        super(Arrays.asList(EP_NAME.getExtensions()), null);
    }

    @Nullable
    protected LocalQuickFix createRenameFix() {
        return new RenameFix();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitField(PsiField field) {
                String name = field.getName();
                if (name != null) {
                    FieldNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)field, name, holder);
                }
            }
        };
    }

    static class FieldNamingConventionBean
    extends NamingConventionBean {
        FieldNamingConventionBean(String regex, int minLength, int maxLength) {
            super(regex, minLength, maxLength, new String[]{"serialVersionUID"});
        }
    }
}

