/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.AbstractNamingConventionInspection;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.siyeh.ig.fixes.RenameFix;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class NewClassNamingConventionInspection
extends AbstractNamingConventionInspection<PsiClass> {
    public static final ExtensionPointName<NamingConvention<PsiClass>> EP_NAME = ExtensionPointName.create((String)"com.intellij.naming.convention.class");

    public NewClassNamingConventionInspection() {
        super(Arrays.asList(EP_NAME.getExtensions()), "ClassNamingConvention");
    }

    protected LocalQuickFix createRenameFix() {
        return new RenameFix();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!(holder.getFile() instanceof PsiClassOwner)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                String name = aClass.getName();
                if (name == null) {
                    return;
                }
                NewClassNamingConventionInspection.this.checkName((PsiNameIdentifierOwner)aClass, name, holder);
            }
        };
    }
}

