/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class NonExceptionNameEndsWithExceptionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String name = (String)infos[0];
        Boolean onTheFly = (Boolean)infos[1];
        if (onTheFly.booleanValue()) {
            return new InspectionGadgetsFix[]{new RenameFix(), new ExtendExceptionFix(name)};
        }
        return new InspectionGadgetsFix[]{new ExtendExceptionFix(name)};
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonExceptionNameEndsWithExceptionVisitor();
    }

    private static class NonExceptionNameEndsWithExceptionVisitor
    extends BaseInspectionVisitor {
        private NonExceptionNameEndsWithExceptionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String exception = "Exception";
            if (!className.endsWith("Exception")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            this.registerClassError(aClass, className, this.isOnTheFly());
        }
    }

    private static class ExtendExceptionFix
    extends InspectionGadgetsFix {
        private final String name;

        ExtendExceptionFix(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.quickfix", this.name);
        }

        @NotNull
        public String getFamilyName() {
            return "Make class extend 'Exception'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            GlobalSearchScope scope = aClass.getResolveScope();
            PsiJavaCodeReferenceElement reference = factory.createReferenceElementByFQClassName("java.lang.Exception", scope);
            CommentTracker tracker = new CommentTracker();
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                tracker.delete((PsiElement)referenceElement);
            }
            tracker.insertCommentsBefore(extendsList.add((PsiElement)reference));
        }
    }
}

