/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class QuestionableNameInspection
extends BaseInspection {
    @NonNls
    public String nameString = "aa,abc,bad,bar,bar2,baz,baz1,baz2,baz3,bb,blah,bogus,bool,cc,dd,defau1t,dummy,dummy2,ee,fa1se,ff,foo,foo1,foo2,foo3,foobar,four,fred,fred1,fred2,gg,hh,hello,hello1,hello2,hello3,ii,nu11,one,silly,silly2,string,two,that,then,three,whi1e,var";
    List<String> nameList = new ArrayList<String>(32);

    public QuestionableNameInspection() {
        QuestionableNameInspection.parseString(this.nameString, this.nameList);
    }

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel(this.nameList, InspectionGadgetsBundle.message("questionable.name.column.title", new Object[0])));
        return UiUtils.createAddRemovePanel(table);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("questionable.name.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("questionable.name.problem.descriptor", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        QuestionableNameInspection.parseString(this.nameString, this.nameList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.nameString = QuestionableNameInspection.formatString(this.nameList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new QuestionableNameVisitor();
    }

    private class QuestionableNameVisitor
    extends BaseInspectionVisitor {
        private final Set<String> nameSet;

        private QuestionableNameVisitor() {
            this.nameSet = new HashSet<String>(QuestionableNameInspection.this.nameList);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            String name = variable.getName();
            if (this.nameSet.contains(name)) {
                this.registerVariableError(variable, new Object[0]);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String name = method.getName();
            if (this.nameSet.contains(name)) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String name = aClass.getName();
            if (this.nameSet.contains(name)) {
                this.registerClassError(aClass, new Object[0]);
            }
        }
    }
}

