/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BigDecimalMethodWithoutRoundingCalledInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("big.decimal.method.without.rounding.called.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("big.decimal.method.without.rounding.called.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalMethodWithoutRoundingCalledVisitor();
    }

    private static class BigDecimalMethodWithoutRoundingCalledVisitor
    extends BaseInspectionVisitor {
        private BigDecimalMethodWithoutRoundingCalledVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"setScale".equals(name) && !"divide".equals(name)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (PsiUtilCore.hasErrorElementChild((PsiElement)argumentList)) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.math.BigDecimal")) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

