/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

class ConvertOctalLiteralToDecimalFix
extends InspectionGadgetsFix {
    ConvertOctalLiteralToDecimalFix() {
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("convert.octal.literal.to.decimal.literal.quickfix", new Object[0]);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiLiteralExpression)) {
            return;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
        ConvertOctalLiteralToDecimalFix.replaceWithDecimalLiteral(literalExpression);
    }

    static void replaceWithDecimalLiteral(PsiLiteralExpression literalExpression) {
        Object value2 = literalExpression.getValue();
        if (value2 == null) {
            return;
        }
        String decimalText = value2 + (PsiType.LONG.equals((Object)literalExpression.getType()) ? "L" : "");
        PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, decimalText);
    }
}

