/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class RemoveLeadingZeroesFix
extends InspectionGadgetsFix {
    RemoveLeadingZeroesFix() {
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("remove.leading.zeroes.to.make.decimals.quickfix", new Object[0]);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiArrayInitializerExpression)) {
            return;
        }
        PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)element;
        for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
            PsiLiteralExpression literal;
            if (!((initializer = ParenthesesUtils.stripParentheses(initializer)) instanceof PsiLiteralExpression) || !ExpressionUtils.isOctalLiteral(literal = (PsiLiteralExpression)initializer)) continue;
            RemoveLeadingZeroFix.removeLeadingZeroes(literal);
        }
    }
}

